/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.TimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Jorgen
 */
public class ToolBoxTest 
{
    
    public ToolBoxTest() 
    {
    }
    
    @BeforeClass
    public static void setUpClass() 
    {
    }
    
    @AfterClass
    public static void tearDownClass() 
    {
    }
    
    @Before
    public void setUp() 
    {
    }
    
    @After
    public void tearDown() 
    {
    }

    /**
     * Test of bytesToDateTime method, of class ToolBox.
     */
    @Test
    public void testBytesToDateTime() 
    {
        System.out.println("bytesToDateTime");
        byte byte0 = (byte)0xF6;
        byte byte1 = (byte)0x7B;
        byte byte2 = (byte)0x30;
        byte byte3 = (byte)0x0F;
        byte byte4 = (byte)0xA1;
        DateTime expResult = new DateTime(2015,06,15,12,48,04,0);
        DateTime result = ToolBox.bytesToDateTime(byte0, byte1, byte2, byte3, byte4);
        assertEquals(expResult, result);
    }

    /**
     * Test of convertUtcToLocal method, of class ToolBox.
     * Assumes time zone Europe/Amsterdam
     */
    @Test
    public void testConvertUtcToLocal() 
    {
        DateTime expResult =null;
        
        System.out.println("convertUtcToLocal");

        TimeZone localTimeZone=TimeZone.getDefault();
        
        DateTime utcDateTime = new DateTime(2015,06,15,12,48,04,0);
        
        if (localTimeZone.observesDaylightTime())
        {
            expResult = new DateTime(2015,06,15,14,48,04,0);
        }
        else
        {
            expResult = new DateTime(2015,06,15,13,48,04,0);
        }
        DateTime result = ToolBox.convertUtcToLocal(utcDateTime);
        assertEquals(expResult, result);
    }

    /**
     * Test of bytesToIntLe method, of class ToolBox.
     */
    @Test
    public void testBytesToIntLe() 
    {
        System.out.println("bytesToIntLe");
        byte[] array = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06};
        int offset = 2;
        int length = 2;
        int expResult = 0x0302;
        int result = ToolBox.bytesToIntLe(array, offset, length);
        assertEquals(expResult, result);

        offset = 2;
        length = 4;
        expResult = 0x05040302;
        result = ToolBox.bytesToIntLe(array, offset, length);
        assertEquals(expResult, result);
    
    }

    /**
     * Test of copyBytes method, of class ToolBox.
     */
    @Test
    public void testCopyBytes() 
    {
        System.out.println("copyBytes");
        byte[] source = {0x00, 0x01, 0x03, 0x04, 0x05};
        byte[] dest = {0x00, 0x00};
        int offset = 2;
        int length = 2;
        ToolBox.copyBytes(source, dest, offset, length);
        assertEquals(dest[0], (byte)0x03);
        assertEquals(dest[1], (byte)0x04);
    }
    
}
