/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * This class represents the waypoint log
 * @author Jorgen
 */
public class WaypointLog
{
    /** The instance of this singleton class */
    private static WaypointLog theInstance=null;

    /** The log of waypointsn */
    private ArrayList<Waypoint> theLog;

    /** Type of the device that logged the waypoints */
    private Device.DeviceType deviceType;

    /**
     * The private constructor of this Singleton class.
     */
    private WaypointLog()
    {
        theLog=new ArrayList<Waypoint>();
        deviceType=Device.DeviceType.DEVICETYPE_UNKNOWN;
    }

    /**
     * This method returns the one and only instance of this Singleton class.
     * @return The instance
     */
    public static WaypointLog getInstance()
    {
        if (theInstance==null)
        {
            theInstance=new WaypointLog();
        }
        return theInstance;
    }

    /**
     * This method clears the waypoint log. All entries are removed.
     */
    public void clear()
    {
        theLog.clear();
    }

    /**
     * This method parses the data passed. It extracts the Waypoints
     * @param data The data
     * @param lenght The datalenght. Multiple of 24 bytes
     * @return False if the end of the waypoints is found, true if not.
     */
    public boolean appendData(byte[] data, int length)
    {
        boolean hasMoreData;
        int         count;
        int         maxCount;
        int         j;
        int         start;
        int         longitude;
        int         latitude;
        int         elevation;
        int         id;
        long        time;
        int         offset;
        Waypoint    point;


        if (length%Waypoint.WAYPOINT_RECORDSIZE!=0)
        {
            DebugLogger.error("Waypoint data has invalid length");
        }

        hasMoreData =true;
        count       =0;
        maxCount    =length/Waypoint.WAYPOINT_RECORDSIZE;
        while (hasMoreData && count<maxCount)
        {
            offset=Waypoint.WAYPOINT_RECORDSIZE*count;
            start=((data[offset+0]&0xff))+
                  ((data[offset+1]&0xff)<<8)+
                  ((data[offset+2]&0xff)<<16)+
                  ((data[offset+3]&0xff)<<24);

            if (start==0x0220485A)
            {
                latitude =((data[offset+ 4]&0xff))+
                          ((data[offset+ 5]&0xff)<<8)+
                          ((data[offset+ 6]&0xff)<<16)+
                          ((data[offset+ 7])<<24);
                longitude=((data[offset+ 8]&0xff))+
                          ((data[offset+ 9]&0xff)<<8)+
                          ((data[offset+10]&0xff)<<16)+
                          ((data[offset+11])<<24);
                elevation=((data[offset+12]&0xff))+
                          ((data[offset+13]&0xff)<<8)+
                          ((data[offset+14]&0xff)<<16)+
                          ((data[offset+15])<<24);
                time     =((data[offset+16]&0xff))+
                          ((data[offset+17]&0xff)<<8)+
                          ((data[offset+18]&0xff)<<16)+
                          ((data[offset+19]&0xff)<<24);
                id       =((data[offset+20]&0xff))+
                          ((data[offset+21]&0xff)<<8)+
                          ((data[offset+22]&0xff)<<16)+
                          ((data[offset+23]&0xff)<<24);

                point=new Waypoint(time, longitude, latitude, elevation, id);
                theLog.add(point);

                count++;
            }
            else
            {
                hasMoreData=false;
            }
        }

        return hasMoreData;
    }

    /**
     * Returns the number of waypoints in the log
     * @return Number of waypoints 
     */
    public int getNumberOfEntries()
    {
        return theLog.size();
    }

    /**
     * Dump the waypoint log to the DebugLogger
     */
    public void dumpLog()
    {
        Iterator<Waypoint>  e;
        Waypoint            point;

        e=theLog.iterator();

        while (e.hasNext())
        {
            point=e.next();
            DebugLogger.info(point.toString());
        }
    }

    /**
     * This method returns the vector with waypoints.
     * @return The vector containing the waypoints.
     */
    public ArrayList<Waypoint> getWaypoints()
    {
        return theLog;
    }

    /**
     * This method sets the type of the device that logged the waypoints.
     * @param deviceType The device type as defined in the Device class
     */
    public void setDeviceType(Device.DeviceType deviceType)
    {
        this.deviceType=deviceType;
    }

    /**
     * This method returns the type of the device that logged the waypoints.
     * @return The type of device as defined in Device class
     */
    public Device.DeviceType getDeviceType()
    {
        return deviceType;
    }


}
