/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.TimeZone;
import java.util.Date;
import java.text.SimpleDateFormat;

/**
 *
 * @author UserXP
 */
public class Waypoint extends Coordinate
{
    public static long  EPOCH_1999_12_31_00_00_00=946598400;
    public static int   WAYPOINT_RECORDSIZE=24;

    private DateTime    timeStamp;
    private int         id;

    /**
     * Constructor
     * @param time GMT Time as number of seconds since 31-12-1999 00:00:00
     * @param longitude Longitude in 10E-7 degrees
     * @param latitude Latitude in 10E-7 degrees
     * @param elevation Elevation in cm
     */
    public Waypoint(long time, int longitude, int latitude, int elevation, int id)
    {
        super(longitude, latitude, elevation);

        SimpleDateFormat    formatter;
        String              dateTimeString;


        // The format that DateTime swallows
        formatter       = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        // It must be formatted in GMT
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));

        // Convert time to timesting
        dateTimeString  = formatter.format(new Date((time+EPOCH_1999_12_31_00_00_00)*1000));
        
        // Create the timestamp
        timeStamp       =new DateTime(dateTimeString);

        // The rest
        this.id         =id;
    }

    /**
     * This method returns the id. The id is a number 101-999, corresponding
     * to POI number as displayed on the device.
     * @return the Id as displayed on the device
     */
    public int getId()
    {
        return id+100;
    }

    /**
     * This method returns the date time stamp in UTC.
     * @return The date time stamp of the record
     */
    public DateTime getDateTime()
    {
        return timeStamp;
    }

    public String toString()
    {
        return new String("Waypoint "+String.format("%3d", getId())+" "+
                          timeStamp.format("DD-MM-YYYY hh:mm:ss")+" "+
                          "Lon "+String.format("%5.3f", getLongitude())+" "+
                          "Lat "+String.format("%5.3f", getLatitude())+" "+
                          "Ele "+String.format("%5.3f", getElevation()));
    }

}
