/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

//import gnu.io.CommPortIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 *
 * @author jorgen
 */
public class UgotmeView extends JFrame implements ProgressListener
{

    /**
     * Creates new form UgotmeViewNew
     */
    public UgotmeView()
    {
        this.setResizable(false);
        initComponents();
        
        initFunctionality();

    }

    /* ************************************************************************\
     * Functionality
     * ************************************************************************/
    /**
     * Initialise the functionality embedded in this view
     */
    void initFunctionality()
    {
        GpxWriter gpxWriter;
        
        executingCommand=false;
        process         =CommunicationProcess.getInstance();

        settings        =Settings.getInstance();

        trackListModel  =new DefaultListModel();
        jListTracks.setModel(trackListModel);

        updatePortList();
        
        // Set the debuglogging conform the state of the logger
        // defined in the application by means of a property
        if (DebugLogger.getDebugLevel()==DebugLogger.DEBUGLEVEL_OFF)
        {
            debugLevelOffRadioButton.setSelected(true);
        }
        else if (DebugLogger.getDebugLevel()==DebugLogger.DEBUGLEVEL_DEBUG)
        {
            debugLevelDebugRadioButton.setSelected(true);
        }
        else if (DebugLogger.getDebugLevel()==DebugLogger.DEBUGLEVEL_INFO)
        {
            debugLevelInfoRadioButton.setSelected(true);
        }
        else
        {
            debugLevelErrorRadioButton.setSelected(true);
        }

        // Create the file name extension filters for the file input boxes
        gpxFileFilter=new FileNameExtensionFilter("GPX files (*.gpx)", "GPX"); 
        tcxFileFilter=new FileNameExtensionFilter("TCX files (*.tcx)", "TCX"); 
        csvFileFilter=new FileNameExtensionFilter("CSV files (*.txt)", "TXT"); 
        
        if (settings.getOutputFileType().equals("TCX"))
        {
            this.tcxMenuItem.setSelected(true);
        }
        else if (settings.getOutputFileType().equals("TXT"))
        {
            this.tcxMenuItem.setSelected(true);
        }
        else
        {
            gpxWriter=GpxWriter.getInstance();

            if (settings.getGpxVersion().equals("1.0"))
            {
                gpxWriter.setGpxVersion("1.0");
                this.jMenuOptions_FileOutputType.setSelected(true);
            }
            else
            {
                this.gpx1_1MenuItem.setSelected(true);
                gpxWriter.setGpxVersion("1.1");
            }
        }
        
        if (settings.getMapType().equals(MapFrame.MAPTYPE_ROAD))
        {
            MapFrame.setMapType(MapFrame.MAPTYPE_ROAD);
            this.roadMenuItem.setSelected(true);
        }
        else if (settings.getMapType().equals(MapFrame.MAPTYPE_SATELLITE))
        {
            MapFrame.setMapType(MapFrame.MAPTYPE_SATELLITE);
            this.satelliteMenuItem.setSelected(true);
        }
        else if (settings.getMapType().equals(MapFrame.MAPTYPE_TERRAIN))
        {
            MapFrame.setMapType(MapFrame.MAPTYPE_TERRAIN);
            this.terrainMenuItem.setSelected(true);
        }
        else if (settings.getMapType().equals(MapFrame.MAPTYPE_HYBRID))
        {
            MapFrame.setMapType(MapFrame.MAPTYPE_HYBRID);
            this.hybridMenuItem.setSelected(true);
        }

            
        if (!settings.getDebugging())
        {
            this.debugMenu.setVisible(false);
        }
 /*           
        this.bitmapContainer.setVisible(false);
        bitmapPane=new BitmapPane();
        bitmapPane.setVisible(true);
        this.bitmapContainer.add(bitmapPane);
        bitmapPane.repaint();
*/
    }

    
    /**
     * This method updates the comport list.
     */
    private void updatePortList()
    {
        int                 i;
        int                 numberOfItems;
        String              item;
        String              comport;
        ArrayList<String>   comportNames;

        
        
        
        jComboBoxComport.removeAllItems();
        comportNames=Device.getInstance().getConnection().getComportList();
        i=0;
        while (i<comportNames.size())
        {
            jComboBoxComport.addItem(comportNames.get(i));
            i++;
        }
        
        if (settings.isSimulationMode())
        {
            // If the system runs in simulation, indicate it in the comport 
            // combo
/*
            jComboBoxComport.removeAllItems();
            jComboBoxComport.addItem("simulation");           
*/            
        }
        else
        {
/*            
            // Else, scan the comports
            portIdentifiers = CommPortIdentifier.getPortIdentifiers();
            jComboBoxComport.removeAllItems();
            while (portIdentifiers.hasMoreElements())
            {
                 pid = (CommPortIdentifier) portIdentifiers.nextElement();
                 jComboBoxComport.addItem(pid.getName());
            }
*/
            
            
            // If the defaultComport is defined, try to select it in the
            // comport combobox. If it is not found, print a warning.
            comport=settings.getComport();
            if (!comport.equals(""))
            {
                jComboBoxComport.setSelectedItem(comport);

                if (!comport.equals(jComboBoxComport.getSelectedItem()))
                {
                    jTextAreaOutput.setText("Comport "+comport+
                                            " (defined in the properties file) not found.\n"+
                                            "Make sure to connect the "+
                                            "device before starting the software");
                }
            }
            else
            {
                jTextAreaOutput.setText("No comport defined in the properties file");
            }
        }
    }

    /**
     * This method saves the waypoints stored in the Waypoint log
     */
    private void saveWaypointsToGpx()
    {
        JFileChooser            fc;
        FileFilter              filter;
        int                     returnValue;
        String                  fileName;
        String                  path;
        String                  extension;
        WaypointLog             log;

        log=WaypointLog.getInstance();

        if (log.getNumberOfEntries()>0)
        {
            fc= new JFileChooser();

            path=settings.getGpxPath();
            if (!path.equals(""))
            {
                fc.setCurrentDirectory(new File(path));
            }

            // Set file extension filters
            fc.addChoosableFileFilter(gpxFileFilter);
            fc.addChoosableFileFilter(csvFileFilter);
            // Don't allow user to select 'all files'
            fc.setAcceptAllFileFilterUsed(false);

            if (settings.getOutputFileType().equals("CSV"))
            {
                fc.setFileFilter(csvFileFilter);
            }
            else
            {
                fc.setFileFilter(gpxFileFilter);
            }
            

            //In response to a button click:
            returnValue = fc.showSaveDialog(mainPanel);


            if (returnValue == JFileChooser.APPROVE_OPTION)
            {
                filter=fc.getFileFilter();
                if (filter.equals(this.csvFileFilter))
                {
                    writer=CsvWriter.getInstance();
                    extension=".txt";                     
                }
                else if (filter.equals(this.gpxFileFilter))
                {
                    writer=GpxWriter.getInstance();
                    extension=".gpx";                     
                }
                else
                {
                    writer=GpxWriter.getInstance();
                    extension=".gpx";                     
                    DebugLogger.error("Invalid file extension chosen. Assuming .gpx");
                }
                
                path=fc.getCurrentDirectory().toString();
                settings.setGpxPath(path);
                fileName=path+"/"+
                         fc.getSelectedFile().getName().toString();

                // Make sure the extension is .gpx/.txt/.tcx
                if(!fileName.toLowerCase().endsWith(extension))
                {
                    fileName +=extension;
                }

                writer.writeWaypointsToFile(fileName);

                jTextAreaOutput.setText("File saved to " + fileName + "!\n");
            }
            if (returnValue == JFileChooser.CANCEL_OPTION)
            {
                jTextAreaOutput.setText("File not saved!\n");

            }
        }
        else
        {
            jTextAreaOutput.setText("No waypoints found. Nothing to save\n");
        }
    }
    
    /**
     *  This method displays the waypoints on a Google static map
     */
    private void showWaypoints()
    {
        MapFrame    mapFrame;
        String      resultString;
        WaypointLog waypointLog;

        jTextAreaOutput.removeAll();        
        waypointLog=WaypointLog.getInstance();
        
        if (waypointLog.getNumberOfEntries()>0)
        {
            mapFrame=new MapFrame();
            resultString=mapFrame.showWaypoints();
            jTextAreaOutput.setText(resultString);        
        }
        else
        {
            jTextAreaOutput.setText("There are no waypoints to show");
        }
    }

    /**
     * This method saves the waypoints stored in the Waypoint log
     */
    private void saveRouteToGpx()
    {
        JFileChooser            fc;
        FileFilter              filter;
        int                     returnValue;
        String                  fileName;
        String                  path;
        String                  extension;
        RouteLog                log;

        log=RouteLog.getInstance();

        if (log.getNumberOfEntries()>0)
        {
            fc= new JFileChooser();

            path=settings.getGpxPath();
            if (!path.equals(""))
            {
                fc.setCurrentDirectory(new File(path));
            }

            // Set file extension filters
            fc.setFileFilter(gpxFileFilter);
            fc.setFileFilter(csvFileFilter);
            // Don't allow user to select 'all files'
            fc.setAcceptAllFileFilterUsed(false);
            if (settings.getOutputFileType().equals("CSV"))
            {
                fc.setFileFilter(csvFileFilter);
            }
            else
            {
                fc.setFileFilter(gpxFileFilter);
            }  

            //In response to a button click:
            returnValue = fc.showSaveDialog(mainPanel);


            if (returnValue == JFileChooser.APPROVE_OPTION)
            {
                filter=fc.getFileFilter();
                if (filter.equals(this.csvFileFilter))
                {
                    writer=CsvWriter.getInstance();
                    extension=".txt";                     
                }
                else if (filter.equals(this.gpxFileFilter))
                {
                    writer=GpxWriter.getInstance();
                    extension=".gpx";                     
                }
                else
                {
                    writer=GpxWriter.getInstance();
                    extension=".gpx";                     
                    DebugLogger.error("Invalid file extension chosen. Assuming .gpx");
                }

                path=fc.getCurrentDirectory().toString();
                settings.setGpxPath(path);
                fileName=path+"/"+
                         fc.getSelectedFile().getName().toString();

                // Make sure the extension is .gpx/.txt/.tcx
                if(!fileName.toLowerCase().endsWith(extension))
                {
                    fileName +=extension;
                }

                writer.writeRouteToFile(fileName);

                jTextAreaOutput.setText("File saved to " + fileName + "!\n");
            }
            if (returnValue == JFileChooser.CANCEL_OPTION)
            {
                jTextAreaOutput.setText("File not saved!\n");

            }
        }
        else
        {
            jTextAreaOutput.setText("No route found. Nothing to save\n");
        }
    }


    /**
     * This method reads a route from GPX file
     * @return True if a route file was read, false if canceled
     */
    private boolean readRouteFromGpx()
    {
        JFileChooser            fc;
        int                     returnValue;
        String                  fileName;
        String                  path;
        boolean                 fileRead;


        fileRead=false;

        fc= new JFileChooser();

        fc.setDialogTitle("Read route");
        path=settings.getGpxPath();
        if (!path.equals(""))
        {
            fc.setCurrentDirectory(new File(path));
        }


        fc.setFileFilter(gpxFileFilter);
        // Don't allow user to select 'all files'
        fc.setAcceptAllFileFilterUsed(false);


        //In response to a button click:
        returnValue = fc.showOpenDialog(mainPanel);


        if (returnValue == JFileChooser.APPROVE_OPTION)
        {
            path=fc.getCurrentDirectory().toString();
            settings.setGpxPath(path);
            fileName=path+"/"+
                     fc.getSelectedFile().getName().toString();

            // Make sure the extension is .gpx
            if(!fileName.toLowerCase().endsWith(".gpx"))
            {
                fileName +=".gpx";
            }


            GpxReader reader=GpxReader.getInstance();
            reader.readRouteFromFile(fileName);

            jTextAreaOutput.setText("File read from " + fileName + "!\n");

            fileRead=true;
//bitmapPane.repaint();
        }
        if (returnValue == JFileChooser.CANCEL_OPTION)
        {
            jTextAreaOutput.setText("No file read!\n");
        }
        return fileRead;
    }

    /**
     *  This method displays the waypoints on a Google static map
     */
    private void showRoute()
    {
        MapFrame    mapFrame;
        String      resultString;
        RouteLog    routeLog;

        jTextAreaOutput.removeAll();        
        routeLog=RouteLog.getInstance();
        
        if (routeLog.getNumberOfEntries()>0)
        {
            mapFrame=new MapFrame();
            resultString=mapFrame.showRoute();
            jTextAreaOutput.setText(resultString);        
        }
        else
        {
            jTextAreaOutput.setText("There is no route to show");
        }
    }    
    

    /**
     * This method saves the track to GPX file
     */
    private void saveTrackToGpx()
    {
        int                     selection;
        JFileChooser            fc;
        FileFilter              filter;
        int                     returnValue;
        String                  fileName;
        String                  path;
        String                  extension;


        selection=jListTracks.getSelectedIndex();

        if (selection>=0)
        {
            fc= new JFileChooser();

            path=settings.getGpxPath();
            if (!path.equals(""))
            {
                fc.setCurrentDirectory(new File(path));
            }

            // Set file extension filters
            fc.addChoosableFileFilter(gpxFileFilter);
            fc.addChoosableFileFilter(tcxFileFilter);
            fc.addChoosableFileFilter(csvFileFilter);
            // Don't allow user to select 'all files'
            fc.setAcceptAllFileFilterUsed(false);
            if (settings.getOutputFileType().equals("CSV"))
            {
                fc.setFileFilter(csvFileFilter);
            }
            else if (settings.getOutputFileType().equals("TCX"))
            {
                fc.setFileFilter(tcxFileFilter);
            }
            else
            {
                fc.setFileFilter(gpxFileFilter);
            }            


            //In response to a button click:
            returnValue = fc.showSaveDialog(mainPanel);


            if (returnValue == JFileChooser.APPROVE_OPTION)
            {
                filter=fc.getFileFilter();
                if (filter.equals(this.csvFileFilter))
                {
                    writer=CsvWriter.getInstance();
                    extension=".txt";                     
                }
                else if (filter.equals(this.tcxFileFilter))
                {
                    writer=TcxWriter.getInstance();
                    extension=".tcx";                     
                }
                else if (filter.equals(this.gpxFileFilter))
                {
                    writer=GpxWriter.getInstance();
                    extension=".gpx";                     
                }
                else
                {
                    writer=GpxWriter.getInstance();
                    extension=".gpx";                     
                    DebugLogger.error("Invalid file extension chosen. Assuming .gpx");
                }
                
                path=fc.getCurrentDirectory().toString();
                settings.setGpxPath(path);
                fileName=path+"/"+
                         fc.getSelectedFile().getName().toString();

                // Make sure the extension is .gpx/.tcx/.txt
                if(!fileName.toLowerCase().endsWith(extension))
                {
                    fileName +=extension;
                }

                writer.writeTrackToFile(fileName, selection, "track"+selection);

                jTextAreaOutput.setText("File saved to " + fileName + "!\n");
            }
            if (returnValue == JFileChooser.CANCEL_OPTION)
            {
                jTextAreaOutput.setText("File not saved!\n");

            }
        }
        else
        {
            jTextAreaOutput.setText("First, select a track...\n");
        }

    }

    /**
     * This method saves the track to GPX file
     */
    private void saveHeartRate()
    {
        int                     selection;
        JFileChooser            fc;
        FileFilter              filter;
        int                     returnValue;
        String                  fileName;
        String                  path;
        String                  extension;


        selection=jListTracks.getSelectedIndex();

        if (selection>=0)
        {
            fc= new JFileChooser();

            path=settings.getGpxPath();
            if (!path.equals(""))
            {
                fc.setCurrentDirectory(new File(path));
            }

            // Set file extension filters
            fc.addChoosableFileFilter(csvFileFilter);
            // Don't allow user to select 'all files'
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(csvFileFilter);


            //In response to a button click:
            returnValue = fc.showSaveDialog(mainPanel);


            if (returnValue == JFileChooser.APPROVE_OPTION)
            {
                writer=CsvWriter.getInstance();
                extension=".txt";
                
                path=fc.getCurrentDirectory().toString();
                settings.setGpxPath(path);
                fileName=path+"/"+
                         fc.getSelectedFile().getName().toString();

                // Make sure the extension is .gpx/.tcx/.txt
                if(!fileName.toLowerCase().endsWith(extension))
                {
                    fileName +=extension;
                }

                writer.writeHeartRateToFile(fileName, selection);

                jTextAreaOutput.setText("File saved to " + fileName + "!\n");
            }
            if (returnValue == JFileChooser.CANCEL_OPTION)
            {
                jTextAreaOutput.setText("File not saved!\n");

            }
        }
        else
        {
            jTextAreaOutput.setText("First, select a track...\n");
        }

    }
    
    
    /**
     * This method saves the device log entries in the log to text file
     */
    private void saveDeviceLogToTextFile()
    {
        int                     selection;
        JFileChooser            fc;
        FileNameExtensionFilter filter;
        int                     returnValue;
        String                  fileName;
        DeviceLog               deviceLog;
        String                  path;
        
        deviceLog=DeviceLog.getInstance();

        if (deviceLog.getNumberOfEntries()>0)
        {
            fc= new JFileChooser();

            path=settings.getLogPath();
            if (!path.equals(""))
            {
                fc.setCurrentDirectory(new File(path));
            }

            filter = new FileNameExtensionFilter("Text files (*.txt)", "TXT");
            fc.setFileFilter(filter);

            //In response to a button click:
            returnValue = fc.showSaveDialog(mainPanel);


            if (returnValue == JFileChooser.APPROVE_OPTION)
            {
                path=fc.getCurrentDirectory().toString();
                settings.setLogPath(path);
                fileName=path+"/"+
                         fc.getSelectedFile().getName().toString();

                // Make sure the extension is .gpx
                if(!fileName.toLowerCase().endsWith(".txt"))
                {
                    fileName +=".txt";
                }

                // Write the file
                deviceLog.writeToFile(fileName);

                jTextAreaOutput.setText("File saved to " + fileName + "!\n");
            }
            if (returnValue == JFileChooser.CANCEL_OPTION)
            {
                jTextAreaOutput.setText("File not saved!\n");

            }
        }
        else
        {
            jTextAreaOutput.setText("No device log entries found. First download tracks\n");
        }
        
    }


    /**
     * Process the results after downloading the tracks from the Device.
     *
     */
    void processDownloadResults()
    {
        String                  outputString;
        int                     numberOfTracks;
        int                     i;
        String                  description;
        DefaultListModel        model;
        TrackLog                log;

        log=TrackLog.getInstance();

        outputString=process.getResult();
        jTextAreaOutput.setText(outputString);

        model=(DefaultListModel)jListTracks.getModel();
        model.clear();

        numberOfTracks=log.getNumberOfTracks();


        i=0;
        while (i<numberOfTracks)
        {
            description=log.getTrackDescription(i);
            model.addElement(description);
            i++;
        }

        jListTracks.setSelectedIndex(numberOfTracks-1);
    }

    /**
     * Generic processing of the result: just print the output
     */
    void processResults()
    {
        String outputString;

        outputString=process.getResult();
        jTextAreaOutput.setText(outputString);
    }




    /**
     * Callback function by which progress during command execution
     * is reported
     * @param progress The progress (0-100)
     */
    public void reportProgress(int progress)
    {
        // Update the progress bar
        this.jProgressBarDownload.setValue(progress);

        // If command execution has been finished, process the result
        if ((progress==100) && executingCommand)
        {
            switch(command.command)
            {
                case COMMAND_GETDEVICETYPE:
                case COMMAND_GETINFO:
                case COMMAND_SAVESIMULATIONSET:
                case COMMAND_SAVEDEVICESETTINGS:
                case COMMAND_SAVEDEVICESETTINGSASTEXT:
                case COMMAND_VERIFYCACHEFILE:
                case COMMAND_ERASEROUTE:
                    SwingUtilities.invokeLater(
                        new Runnable()
                        {
                            public void run()
                            {
                                processResults();
                            }
                        });
                    break;
                case COMMAND_DOWNLOADTRACKS:
                    // Updating the list from this thread is not a good idea
                    // Therefore invoke updating later from within the UI thread
                    SwingUtilities.invokeLater(
                        new Runnable()
                        {
                            public void run()
                            {
                                processDownloadResults();
                            }
                        });
                    break;
                case COMMAND_DOWNLOADWAYPOINTS:
                    SwingUtilities.invokeLater(
                        new Runnable()
                        {
                            public void run()
                            {
                                processResults();
                                if (nextAfterWaypointDownload==NEXTAFTERWAYPOINTDOWNLOAD_SAVE)
                                {
                                    saveWaypointsToGpx();
                                }
                                else if (nextAfterWaypointDownload==NEXTAFTERWAYPOINTDOWNLOAD_SHOW)
                                {
                                    showWaypoints();
                                }
                            }
                        });
                    break;
                case COMMAND_UPLOADROUTE:
                    SwingUtilities.invokeLater(
                        new Runnable()
                        {
                            public void run()
                            {
                                processResults();
                            }
                        });
                    break;
                case COMMAND_DOWNLOADROUTE:
                    SwingUtilities.invokeLater(
                        new Runnable()
                        {
                            public void run()
                            {
                                processResults();
                                if (nextAfterRouteDownload==NEXTAFTERROUTEDOWNLOAD_SAVE)
                                {
                                    saveRouteToGpx();
                                }
                                else
                                {
                                    showRoute();
                                }
                            }
                        });
                    break;
                case COMMAND_ERASETRACKS:
                    SwingUtilities.invokeLater(
                        new Runnable()
                        {
                            public void run()
                            {
                                processResults();
                            }
                        });
                    break;
            }
            executingCommand=false;
        }

    }

    /**
     * This method initiates command execution.
     * @param commandId The Command to exectue
     * @param messageWhileExecuting Message to display while executing
     * @param param Optional parameter
     */
    private void executeCommand(Command.CommandType commandId, String messageWhileExecuting, String param)
    {
        String                  comport;
        Object                  selectedItem;


        jTextAreaOutput.setText(messageWhileExecuting);

        if (!executingCommand)
        {
            // Get the comport
            selectedItem=this.jComboBoxComport.getSelectedItem();
            
            if (selectedItem!=null)
            {
                // sign that a command is being processed
                executingCommand=true;
            
                comport=selectedItem.toString();


                command=new Command(commandId, comport);

                process.executeCommand(command, this, param);
            }
            else
            {
                jTextAreaOutput.setText("No valid comport. First select device, than start software\n");
            }
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }
    }

    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(UgotmeView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(UgotmeView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(UgotmeView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(UgotmeView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() 
        {

            public void run() {
                new UgotmeView().setVisible(true);
            }
        });
    }
    
    
    
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        buttonGroup3 = new javax.swing.ButtonGroup();
        mainPanel = new javax.swing.JPanel();
        jButtonDownloadTrack = new javax.swing.JButton();
        jProgressBarDownload = new javax.swing.JProgressBar();
        jButtonGetInfo = new javax.swing.JButton();
        jLabelTracks = new javax.swing.JLabel();
        jLabelProgress = new javax.swing.JLabel();
        jButtonEraseTracks = new javax.swing.JButton();
        jLabelOutput = new javax.swing.JLabel();
        jButtonSaveTrack = new javax.swing.JButton();
        jButtonUploadRoute = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jListTracks = new javax.swing.JList();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaOutput = new javax.swing.JTextArea();
        jLabelComport = new javax.swing.JLabel();
        jComboBoxComport = new javax.swing.JComboBox();
        jButtonShowWaypoints = new javax.swing.JButton();
        jButtonShowRoute = new javax.swing.JButton();
        jButtonShowTrack = new javax.swing.JButton();
        jButtonSaveRoute = new javax.swing.JButton();
        jButtonSaveWaypoints = new javax.swing.JButton();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuDevice = new javax.swing.JMenu();
        jMenuItemGetDeviceType = new javax.swing.JMenuItem();
        jMenuItemGetInfo = new javax.swing.JMenuItem();
        jMenuItemSaveDeviceLog = new javax.swing.JMenuItem();
        jMenuItemRescanComports = new javax.swing.JMenuItem();
        jMenuTracks = new javax.swing.JMenu();
        jMenuItemDownloadTracks = new javax.swing.JMenuItem();
        jMenuItemEraseTracks = new javax.swing.JMenuItem();
        jMenuItemSaveTracks = new javax.swing.JMenuItem();
        jMenuItem5 = new javax.swing.JMenuItem();
        jMenuItem6 = new javax.swing.JMenuItem();
        jMenuItem7 = new javax.swing.JMenuItem();
        jMenuItemShowSpeed = new javax.swing.JMenuItem();
        jMenuWaypoints = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItemShowWaypoints = new javax.swing.JMenuItem();
        jMenuRoutes = new javax.swing.JMenu();
        jMenuItemDownloadRoute = new javax.swing.JMenuItem();
        jMenuItemUploadRoute = new javax.swing.JMenuItem();
        jMenuItemShowRoute = new javax.swing.JMenuItem();
        jMenuItemDeleteRoute = new javax.swing.JMenuItem();
        jMenuOptions = new javax.swing.JMenu();
        jMenuOptions_FileOutputType = new javax.swing.JMenu();
        gpx1_0MenuItem = new javax.swing.JRadioButtonMenuItem();
        gpx1_1MenuItem = new javax.swing.JRadioButtonMenuItem();
        tcxMenuItem = new javax.swing.JRadioButtonMenuItem();
        csvMenuItem = new javax.swing.JRadioButtonMenuItem();
        jMenuItemMapType = new javax.swing.JMenu();
        roadMenuItem = new javax.swing.JRadioButtonMenuItem();
        satelliteMenuItem = new javax.swing.JRadioButtonMenuItem();
        terrainMenuItem = new javax.swing.JRadioButtonMenuItem();
        hybridMenuItem = new javax.swing.JRadioButtonMenuItem();
        jMenuItemOptions_SaveSettings = new javax.swing.JMenuItem();
        debugMenu = new javax.swing.JMenu();
        jMenu1 = new javax.swing.JMenu();
        debugLevelOffRadioButton = new javax.swing.JRadioButtonMenuItem();
        debugLevelErrorRadioButton = new javax.swing.JRadioButtonMenuItem();
        debugLevelInfoRadioButton = new javax.swing.JRadioButtonMenuItem();
        debugLevelDebugRadioButton = new javax.swing.JRadioButtonMenuItem();
        jMenuItemSaveSimSet = new javax.swing.JMenuItem();
        jMenuItemSaveDeviceSettingsBlock = new javax.swing.JMenuItem();
        jMenuItemSaveDeviceSettings = new javax.swing.JMenuItem();
        menuItemVerifyCacheFile = new javax.swing.JMenuItem();
        jMenuHelp = new javax.swing.JMenu();
        jMenuItemAbout = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jButtonDownloadTrack.setText("Download");
        jButtonDownloadTrack.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDownloadTracks(evt);
            }
        });

        jButtonGetInfo.setText("Get Info");
        jButtonGetInfo.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGetInfo(evt);
            }
        });

        jLabelTracks.setText("Tracks");

        jLabelProgress.setText("Progress");

        jButtonEraseTracks.setText("Erase Tracks");
        jButtonEraseTracks.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionEraseTracks(evt);
            }
        });

        jLabelOutput.setText("Info");

        jButtonSaveTrack.setText("Save Track");
        jButtonSaveTrack.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveTrack(evt);
            }
        });

        jButtonUploadRoute.setText("Upload Route");
        jButtonUploadRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionUploadRoute(evt);
            }
        });

        jListTracks.setFont(new java.awt.Font("Monospaced", 0, 11)); // NOI18N
        jListTracks.setModel(new javax.swing.AbstractListModel()
        {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane2.setViewportView(jListTracks);

        jTextAreaOutput.setColumns(20);
        jTextAreaOutput.setRows(5);
        jScrollPane1.setViewportView(jTextAreaOutput);

        jLabelComport.setText("Comport");

        jComboBoxComport.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jButtonShowWaypoints.setText("Show Waypoints");
        jButtonShowWaypoints.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowWaypoints(evt);
            }
        });

        jButtonShowRoute.setText("Show Route");
        jButtonShowRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowRoute(evt);
            }
        });

        jButtonShowTrack.setText("Show Track");
        jButtonShowTrack.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowTrack(evt);
            }
        });

        jButtonSaveRoute.setText("Save Route");
        jButtonSaveRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveRoute(evt);
            }
        });

        jButtonSaveWaypoints.setText("Save Waypoints");
        jButtonSaveWaypoints.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveWaypointLog(evt);
            }
        });

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addComponent(jLabelProgress)
                        .addGap(18, 18, 18)
                        .addComponent(jProgressBarDownload, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                        .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(mainPanelLayout.createSequentialGroup()
                                .addComponent(jLabelComport)
                                .addGap(19, 19, 19)
                                .addComponent(jComboBoxComport, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jButtonDownloadTrack, javax.swing.GroupLayout.PREFERRED_SIZE, 125, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonSaveTrack, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(mainPanelLayout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonEraseTracks, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonShowTrack)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(mainPanelLayout.createSequentialGroup()
                                .addComponent(jButtonSaveWaypoints)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonSaveRoute)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonGetInfo, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                                .addComponent(jButtonShowWaypoints)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonShowRoute)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonUploadRoute, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addComponent(jScrollPane2)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelOutput)
                            .addComponent(jLabelTracks))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );

        mainPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonDownloadTrack, jButtonEraseTracks, jButtonGetInfo, jButtonSaveRoute, jButtonSaveTrack, jButtonSaveWaypoints, jButtonShowRoute, jButtonShowTrack, jButtonShowWaypoints, jButtonUploadRoute});

        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxComport, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonDownloadTrack)
                    .addComponent(jButtonSaveTrack)
                    .addComponent(jButtonGetInfo)
                    .addComponent(jLabelComport)
                    .addComponent(jButtonSaveRoute)
                    .addComponent(jButtonSaveWaypoints))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonShowWaypoints)
                    .addComponent(jButtonShowRoute)
                    .addComponent(jButtonUploadRoute)
                    .addComponent(jButtonShowTrack)
                    .addComponent(jButtonEraseTracks))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabelProgress)
                    .addComponent(jProgressBarDownload, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelTracks)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 256, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelOutput)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jMenuFile.setText("File");

        jMenuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem2.setText("Quit");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionQuit(evt);
            }
        });
        jMenuFile.add(jMenuItem2);

        jMenuBar1.add(jMenuFile);

        jMenuDevice.setText("Device");

        jMenuItemGetDeviceType.setText("Get Device Type");
        jMenuItemGetDeviceType.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGetDeviceType(evt);
            }
        });
        jMenuDevice.add(jMenuItemGetDeviceType);

        jMenuItemGetInfo.setText("Get Info");
        jMenuItemGetInfo.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGetInfo(evt);
            }
        });
        jMenuDevice.add(jMenuItemGetInfo);

        jMenuItemSaveDeviceLog.setText("Save Device Log");
        jMenuItemSaveDeviceLog.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveDeviceLog(evt);
            }
        });
        jMenuDevice.add(jMenuItemSaveDeviceLog);

        jMenuItemRescanComports.setText("Rescan Comports");
        jMenuItemRescanComports.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionRescanComports(evt);
            }
        });
        jMenuDevice.add(jMenuItemRescanComports);

        jMenuBar1.add(jMenuDevice);

        jMenuTracks.setText("Tracks");

        jMenuItemDownloadTracks.setText("Download Tracks");
        jMenuItemDownloadTracks.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDownloadTracks(evt);
            }
        });
        jMenuTracks.add(jMenuItemDownloadTracks);

        jMenuItemEraseTracks.setText("Erase Tracks");
        jMenuItemEraseTracks.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionEraseTracks(evt);
            }
        });
        jMenuTracks.add(jMenuItemEraseTracks);

        jMenuItemSaveTracks.setText("Save Selected Track");
        jMenuItemSaveTracks.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveTrack(evt);
            }
        });
        jMenuTracks.add(jMenuItemSaveTracks);

        jMenuItem5.setText("Show Selected Track");
        jMenuItem5.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowTrack(evt);
            }
        });
        jMenuTracks.add(jMenuItem5);

        jMenuItem6.setText("Save Heartrate");
        jMenuItem6.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveHeartrate(evt);
            }
        });
        jMenuTracks.add(jMenuItem6);

        jMenuItem7.setText("Show Heartrate");
        jMenuItem7.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionPlotHeartrate(evt);
            }
        });
        jMenuTracks.add(jMenuItem7);

        jMenuItemShowSpeed.setText("Show Speed");
        jMenuItemShowSpeed.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowSpeed(evt);
            }
        });
        jMenuTracks.add(jMenuItemShowSpeed);

        jMenuBar1.add(jMenuTracks);

        jMenuWaypoints.setText("Waypoints");

        jMenuItem1.setText("Save Waypoints");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveWaypointLog(evt);
            }
        });
        jMenuWaypoints.add(jMenuItem1);

        jMenuItemShowWaypoints.setText("Show Waypoints");
        jMenuItemShowWaypoints.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowWaypoints(evt);
            }
        });
        jMenuWaypoints.add(jMenuItemShowWaypoints);

        jMenuBar1.add(jMenuWaypoints);

        jMenuRoutes.setText("Routes");

        jMenuItemDownloadRoute.setText("Save Route");
        jMenuItemDownloadRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveRoute(evt);
            }
        });
        jMenuRoutes.add(jMenuItemDownloadRoute);

        jMenuItemUploadRoute.setText("Upload Route");
        jMenuItemUploadRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionUploadRoute(evt);
            }
        });
        jMenuRoutes.add(jMenuItemUploadRoute);

        jMenuItemShowRoute.setText("Show Route");
        jMenuItemShowRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowRoute(evt);
            }
        });
        jMenuRoutes.add(jMenuItemShowRoute);

        jMenuItemDeleteRoute.setText("Erase Route");
        jMenuItemDeleteRoute.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDeleteRoute(evt);
            }
        });
        jMenuRoutes.add(jMenuItemDeleteRoute);

        jMenuBar1.add(jMenuRoutes);

        jMenuOptions.setText("Options");

        jMenuOptions_FileOutputType.setText("File Output Format");
        jMenuOptions_FileOutputType.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGpxVersion(evt);
            }
        });

        buttonGroup2.add(gpx1_0MenuItem);
        gpx1_0MenuItem.setSelected(true);
        gpx1_0MenuItem.setText("GPX 1.0");
        gpx1_0MenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGpxVersion(evt);
            }
        });
        jMenuOptions_FileOutputType.add(gpx1_0MenuItem);

        buttonGroup2.add(gpx1_1MenuItem);
        gpx1_1MenuItem.setText("GPX 1.1");
        gpx1_1MenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGpxVersion(evt);
            }
        });
        jMenuOptions_FileOutputType.add(gpx1_1MenuItem);

        buttonGroup2.add(tcxMenuItem);
        tcxMenuItem.setText("TCX");
        tcxMenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGpxVersion(evt);
            }
        });
        jMenuOptions_FileOutputType.add(tcxMenuItem);

        buttonGroup2.add(csvMenuItem);
        csvMenuItem.setText("CSV");
        csvMenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionGpxVersion(evt);
            }
        });
        jMenuOptions_FileOutputType.add(csvMenuItem);

        jMenuOptions.add(jMenuOptions_FileOutputType);

        jMenuItemMapType.setText("Map Type");

        buttonGroup3.add(roadMenuItem);
        roadMenuItem.setSelected(true);
        roadMenuItem.setText("Road");
        roadMenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionMapButton(evt);
            }
        });
        jMenuItemMapType.add(roadMenuItem);

        buttonGroup3.add(satelliteMenuItem);
        satelliteMenuItem.setText("Satellite");
        satelliteMenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionMapButton(evt);
            }
        });
        jMenuItemMapType.add(satelliteMenuItem);

        buttonGroup3.add(terrainMenuItem);
        terrainMenuItem.setText("Terrain");
        terrainMenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionMapButton(evt);
            }
        });
        jMenuItemMapType.add(terrainMenuItem);

        buttonGroup3.add(hybridMenuItem);
        hybridMenuItem.setText("Hybrid");
        hybridMenuItem.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionMapButton(evt);
            }
        });
        jMenuItemMapType.add(hybridMenuItem);

        jMenuOptions.add(jMenuItemMapType);

        jMenuItemOptions_SaveSettings.setText("Save Settings");
        jMenuItemOptions_SaveSettings.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveSettings(evt);
            }
        });
        jMenuOptions.add(jMenuItemOptions_SaveSettings);

        jMenuBar1.add(jMenuOptions);

        debugMenu.setText("Debug");

        jMenu1.setText("Debug");

        buttonGroup1.add(debugLevelOffRadioButton);
        debugLevelOffRadioButton.setSelected(true);
        debugLevelOffRadioButton.setText("Off");
        debugLevelOffRadioButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDebugRadioButton(evt);
            }
        });
        jMenu1.add(debugLevelOffRadioButton);

        buttonGroup1.add(debugLevelErrorRadioButton);
        debugLevelErrorRadioButton.setText("Errors");
        debugLevelErrorRadioButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDebugRadioButton(evt);
            }
        });
        jMenu1.add(debugLevelErrorRadioButton);

        buttonGroup1.add(debugLevelInfoRadioButton);
        debugLevelInfoRadioButton.setText("Info");
        debugLevelInfoRadioButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDebugRadioButton(evt);
            }
        });
        jMenu1.add(debugLevelInfoRadioButton);

        buttonGroup1.add(debugLevelDebugRadioButton);
        debugLevelDebugRadioButton.setText("Debug");
        debugLevelDebugRadioButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionDebugRadioButton(evt);
            }
        });
        jMenu1.add(debugLevelDebugRadioButton);

        debugMenu.add(jMenu1);

        jMenuItemSaveSimSet.setText("Save Simulation Set");
        jMenuItemSaveSimSet.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveSimulationSet(evt);
            }
        });
        debugMenu.add(jMenuItemSaveSimSet);

        jMenuItemSaveDeviceSettingsBlock.setText("Save Device Settings Block");
        jMenuItemSaveDeviceSettingsBlock.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveDeviceSettingsBlock(evt);
            }
        });
        debugMenu.add(jMenuItemSaveDeviceSettingsBlock);

        jMenuItemSaveDeviceSettings.setText("Save Device Settings");
        jMenuItemSaveDeviceSettings.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionSaveDeviceSettings(evt);
            }
        });
        debugMenu.add(jMenuItemSaveDeviceSettings);

        menuItemVerifyCacheFile.setText("Verify Cache File");
        menuItemVerifyCacheFile.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionVerifyCacheFile(evt);
            }
        });
        debugMenu.add(menuItemVerifyCacheFile);

        jMenuBar1.add(debugMenu);

        jMenuHelp.setText("Help");

        jMenuItemAbout.setText("About");
        jMenuItemAbout.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                actionShowAboutBox(evt);
            }
        });
        jMenuHelp.add(jMenuItemAbout);

        jMenuBar1.add(jMenuHelp);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(mainPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(mainPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     *  This function downloads the tracks and shows them in the listbox.
     */  
    private void actionDownloadTracks(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionDownloadTracks
    {//GEN-HEADEREND:event_actionDownloadTracks
        if (!executingCommand)
        {
            // Empty the list of tracks.
            this.trackListModel.clear();
        }
        this.executeCommand(Command.CommandType.COMMAND_DOWNLOADTRACKS, "Downloading tracks...", null);  
    }//GEN-LAST:event_actionDownloadTracks

    /**
     *  This method saves the track selected in the track list box
     */ 
    private void actionSaveTrack(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveTrack
    {//GEN-HEADEREND:event_actionSaveTrack
        if (!this.executingCommand)
        {
            jTextAreaOutput.removeAll();
            saveTrackToGpx();
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }       
    }//GEN-LAST:event_actionSaveTrack

    /**
     *  This method erases the tracks from the device
     */ 
    private void actionEraseTracks(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionEraseTracks
    {//GEN-HEADEREND:event_actionEraseTracks
       String   comport;
       int      confirm;


        jTextAreaOutput.removeAll();

        if (!executingCommand)
        {
            confirm=JOptionPane.showConfirmDialog(mainPanel, 
                                                  "Are you sure to erase the tracklog on the device?",
                                                  "Confirm erase",
                                                  JOptionPane.OK_CANCEL_OPTION);

            if (confirm==0)
            {
                this.executeCommand(Command.CommandType.COMMAND_ERASETRACKS, "Erasing... Do not unconnect the device!", null);
/*
                jTextAreaOutput.setText("Erasing... Do not unconnect the device!");
                // sign that a command is being processed
                executingCommand=true;

                // Get the comport
                comport=this.jComboBoxComport.getSelectedItem().toString();

                // Create a new command
                command=new Command(Command.COMMAND_ERASETRACKS, comport);

                // Signal the process to execute the command
                process.executeCommand(command, this, null);
 */
            }
            else
            {
                jTextAreaOutput.setText("Erasing canceled");
            }

        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }
    }//GEN-LAST:event_actionEraseTracks

    
    /**
     * This method handles the upload route button. It presents a
     * file dialog for requesting the GPX file with the route. It triggers
     * the upload.
     */    
    private void actionUploadRoute(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionUploadRoute
    {//GEN-HEADEREND:event_actionUploadRoute
        String                  comport;
        RouteLog                routeLog;
        boolean                 fileRead;

        if (!executingCommand)
        {
            fileRead=readRouteFromGpx();

            if (fileRead)
            {
                routeLog=RouteLog.getInstance();
                if (routeLog.getNumberOfEntries()>0)
                {
                    this.executeCommand(Command.CommandType.COMMAND_UPLOADROUTE, "Uploading route... Don't disconnect device!", null);
                }
                else
                {
                    jTextAreaOutput.setText("No waypoints in route\n");
                }
            }
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }

//bitmapPane.repaint();
    }//GEN-LAST:event_actionUploadRoute

    /**
     * This method retrieves the info from the device
     * @param evt 
     */
    private void actionGetInfo(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionGetInfo
    {//GEN-HEADEREND:event_actionGetInfo
        this.executeCommand(Command.CommandType.COMMAND_GETINFO, "Downloading info...", null);
    }//GEN-LAST:event_actionGetInfo

    
    /**
     * This method handles the debug level radiobutton
     * @param evt 
     */
    private void actionDebugRadioButton(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionDebugRadioButton
    {//GEN-HEADEREND:event_actionDebugRadioButton
        if (debugLevelOffRadioButton.isSelected())
        {
            DebugLogger.setDebugLevel(DebugLogger.DEBUGLEVEL_OFF);
            jTextAreaOutput.setText("Debug level: off\n");
        }
        else if (debugLevelInfoRadioButton.isSelected())
        {
            DebugLogger.setDebugLevel(DebugLogger.DEBUGLEVEL_INFO);
            jTextAreaOutput.setText("Debug level: info\n");
        }
        else if (debugLevelDebugRadioButton.isSelected())
        {
            DebugLogger.setDebugLevel(DebugLogger.DEBUGLEVEL_DEBUG);
            jTextAreaOutput.setText("Debug level: debug\n");
        }
        else if (debugLevelErrorRadioButton.isSelected())
        {
            DebugLogger.setDebugLevel(DebugLogger.DEBUGLEVEL_ERROR);
            jTextAreaOutput.setText("Debug level: error\n");
        }
        else
        {
            DebugLogger.setDebugLevel(DebugLogger.DEBUGLEVEL_ERROR);
            DebugLogger.debug("Debug radio button not selected");
        }
    }//GEN-LAST:event_actionDebugRadioButton


    /**
     * This method downloads the waypoint log and saves it to file
     * @param evt 
     */
    private void actionSaveWaypointLog(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveWaypointLog
    {//GEN-HEADEREND:event_actionSaveWaypointLog
        this.nextAfterWaypointDownload=NEXTAFTERWAYPOINTDOWNLOAD_SAVE;
        this.executeCommand(Command.CommandType.COMMAND_DOWNLOADWAYPOINTS, "Downloading waypoints...", null);
    }//GEN-LAST:event_actionSaveWaypointLog

    /** 
     * This method gets the type of the device
     * @param evt 
     */
    private void actionGetDeviceType(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionGetDeviceType
    {//GEN-HEADEREND:event_actionGetDeviceType
        this.executeCommand(Command.CommandType.COMMAND_GETDEVICETYPE, "Retrieving device type...", null);
    }//GEN-LAST:event_actionGetDeviceType

    /**
     *  This method downloads the route and saves it to file. The route is in
     *  fact the first 100 waypoints.
     * @param evt 
     */
    private void actionSaveRoute(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveRoute
    {//GEN-HEADEREND:event_actionSaveRoute
       nextAfterRouteDownload=NEXTAFTERROUTEDOWNLOAD_SAVE;
       this.executeCommand(Command.CommandType.COMMAND_DOWNLOADROUTE, "Downloading route...", null);
    }//GEN-LAST:event_actionSaveRoute

    /**
     * This method parses the track log and saves the device log records.
     * @param evt 
     */
    private void actionSaveDeviceLog(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveDeviceLog
    {//GEN-HEADEREND:event_actionSaveDeviceLog
        if (!this.executingCommand)
        {
            jTextAreaOutput.removeAll();
            this.saveDeviceLogToTextFile();
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }    
    }//GEN-LAST:event_actionSaveDeviceLog

    
    /**
     * This method handles the saving of the settings.
     * @param evt 
     */
    private void actionSaveSettings(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveSettings
    {//GEN-HEADEREND:event_actionSaveSettings
        Object selectedItem;
        
        selectedItem=this.jComboBoxComport.getSelectedItem();
        if (selectedItem!=null)
        {
            settings.setComport(selectedItem.toString());
        }
        else
        {
            DebugLogger.info("Uhm.. no comport selected when saving settings");

            // yeah, what else...
        }
            

        if (debugLevelOffRadioButton.isSelected())
        {
            settings.setDebugLevel(DebugLogger.DEBUGLEVEL_OFF);
        }
        else if (debugLevelInfoRadioButton.isSelected())
        {
            settings.setDebugLevel(DebugLogger.DEBUGLEVEL_INFO);
        }
        else if (debugLevelDebugRadioButton.isSelected())
        {
            settings.setDebugLevel(DebugLogger.DEBUGLEVEL_DEBUG);
        }
        else if (debugLevelErrorRadioButton.isSelected())
        {
            settings.setDebugLevel(DebugLogger.DEBUGLEVEL_ERROR);
        }
        else
        {
            settings.setDebugLevel(DebugLogger.DEBUGLEVEL_ERROR);
            DebugLogger.debug("Debug radio button not selected when saving settings");
        }
        


        // paths are set elsewhere in the code

        // The output file type and GPX version. Default: GPX 1.1
        if (this.gpx1_0MenuItem.isSelected())
        {
            settings.setOutputFileType("GPX");
            settings.setGpxVersion("1.0");
        }
        else if (this.tcxMenuItem.isSelected())
        {
            settings.setOutputFileType("TCX");
            settings.setGpxVersion("1.1");
        }
        else if (this.csvMenuItem.isSelected())
        {
            settings.setOutputFileType("CSV");
            settings.setGpxVersion("1.1");
        }
        else
        {
            settings.setOutputFileType("GPX");
            settings.setGpxVersion("1.1");
        }
        
        if (this.roadMenuItem.isSelected())
        {
            settings.setMapType(MapFrame.MAPTYPE_ROAD);
        }
        else if (this.satelliteMenuItem.isSelected())
        {
            settings.setMapType(MapFrame.MAPTYPE_SATELLITE);
        } 
        else if (this.terrainMenuItem.isSelected())
        {
            settings.setMapType(MapFrame.MAPTYPE_TERRAIN);
        } 
        else if (this.hybridMenuItem.isSelected())
        {
            settings.setMapType(MapFrame.MAPTYPE_HYBRID);
        } 
        else
        {
            settings.setMapType(MapFrame.MAPTYPE_ROAD);
            DebugLogger.debug("Map type not selected when saving settings");
        }
        
        
        settings.writeSettings();
        jTextAreaOutput.setText("Settings written to "+settings.getPropertyFileName());        

    }//GEN-LAST:event_actionSaveSettings

    
    /**
     *  This method handles the user selecting another GPX version using the
     *  radio button
     * @param evt 
     */
    private void actionGpxVersion(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionGpxVersion
    {//GEN-HEADEREND:event_actionGpxVersion
        GpxWriter gpxWriter;

        
        
        if (this.gpx1_0MenuItem.isSelected())
        {
            settings.setOutputFileType("GPX");
            settings.setGpxVersion("1.0");
            gpxWriter=GpxWriter.getInstance();
            gpxWriter.setGpxVersion("1.0");
            jTextAreaOutput.setText("Output file type set to GPX version set to 1.0\n");
        }
        else if (this.gpx1_1MenuItem.isSelected())
        {
            settings.setOutputFileType("GPX");
            settings.setGpxVersion("1.1");
            gpxWriter=GpxWriter.getInstance();
            gpxWriter.setGpxVersion("1.1");
            jTextAreaOutput.setText("Output file type set to GPX version set to 1.1\n");
        }        
        else if (this.tcxMenuItem.isSelected())
        {
            settings.setOutputFileType("TCX");
            jTextAreaOutput.setText("Output file type set to TCX\n");
        }        
        else if (this.csvMenuItem.isSelected())
        {
            settings.setOutputFileType("CSV");
            jTextAreaOutput.setText("Output file type set to CSV\n");
        } 
    }//GEN-LAST:event_actionGpxVersion

    
    /**
     *  This method shows the selected track on a Google static map
     * @param evt 
     */
    private void actionShowTrack(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionShowTrack
    {//GEN-HEADEREND:event_actionShowTrack
        MapFrame    mapFrame;
        int         selection;
        String      resultString;
  
        selection=jListTracks.getSelectedIndex();

        if (selection>=0)
        {
            mapFrame=new MapFrame();
            resultString=mapFrame.showTrack(selection);
            jTextAreaOutput.removeAll();
            jTextAreaOutput.setText(resultString);
        }
        else
        {
            jTextAreaOutput.setText("First, download tracks and select one...\n");
        }

    }//GEN-LAST:event_actionShowTrack

    /**
     * This method downloads the waypoint log from the device and shows it
     * on the google map
     * @param evt 
     */
    private void actionShowWaypoints(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionShowWaypoints
    {//GEN-HEADEREND:event_actionShowWaypoints
        this.nextAfterWaypointDownload=NEXTAFTERWAYPOINTDOWNLOAD_SHOW;
        this.executeCommand(Command.CommandType.COMMAND_DOWNLOADWAYPOINTS, "Downloading waypoints...", null);
    }//GEN-LAST:event_actionShowWaypoints

    /**
     * This method rescans the comports and updates the combobox
     * @param evt 
     */
    private void actionRescanComports(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionRescanComports
    {//GEN-HEADEREND:event_actionRescanComports
        this.updatePortList();
    }//GEN-LAST:event_actionRescanComports

    /**
     * This method downloads the route from the device and shows it on 
     * a google map
     * @param evt 
     */
    private void actionShowRoute(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionShowRoute
    {//GEN-HEADEREND:event_actionShowRoute
       nextAfterRouteDownload=NEXTAFTERROUTEDOWNLOAD_SHOW;
       this.executeCommand(Command.CommandType.COMMAND_DOWNLOADROUTE, "Downloading route...", null);
    }//GEN-LAST:event_actionShowRoute

    
    /**
     * This method handles the map type selection
     * @param evt 
     */
    private void actionMapButton(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionMapButton
    {//GEN-HEADEREND:event_actionMapButton
        if (this.roadMenuItem.isSelected())
        {
            MapFrame.setMapType("roadmap");
            jTextAreaOutput.setText("Map type set to 'road'\n");
        }
        else if (this.satelliteMenuItem.isSelected())
        {
            MapFrame.setMapType("satellite");
            jTextAreaOutput.setText("Map type set to 'satellite'\n");
        }
        else if (this.terrainMenuItem.isSelected())
        {
            MapFrame.setMapType("terrain");
            jTextAreaOutput.setText("Map type set to 'terrain'\n");
        }
        else if (this.hybridMenuItem.isSelected())
        {
            MapFrame.setMapType("hybrid");
            jTextAreaOutput.setText("Map type set to 'hybrid'\n");
        }

    }//GEN-LAST:event_actionMapButton

    /**
     * Shows the about box...
     * @param evt 
     */
    private void actionShowAboutBox(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionShowAboutBox
    {//GEN-HEADEREND:event_actionShowAboutBox
        if (aboutBox == null)
        {
//            JFrame mainFrame = UgotmeApp.getApplication().getMainFrame();
            aboutBox = new UgotmeAboutBox(this, true);
            aboutBox.setLocationRelativeTo(this);
        }
        UgotmeApp.getApplication().show(aboutBox); 
    }//GEN-LAST:event_actionShowAboutBox

    /**
     * This method saves a dump of the memory and command responses.
     * This data is used by the simulation mode.
     * @param evt 
     */
    private void actionSaveSimulationSet(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveSimulationSet
    {//GEN-HEADEREND:event_actionSaveSimulationSet
        if (!this.executingCommand)
        {
            jTextAreaOutput.removeAll();
            this.executeCommand(Command.CommandType.COMMAND_SAVESIMULATIONSET, "Save simulation set...", settings.getLogPath());
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }   
    }//GEN-LAST:event_actionSaveSimulationSet

    /**
     * This method saves the first block of memory containing the device settings
     * @param evt 
     */
    private void actionSaveDeviceSettingsBlock(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveDeviceSettingsBlock
    {//GEN-HEADEREND:event_actionSaveDeviceSettingsBlock
        if (!this.executingCommand)
        {
            jTextAreaOutput.removeAll();
            this.executeCommand(Command.CommandType.COMMAND_SAVEDEVICESETTINGS, "Save device settings...", settings.getLogPath());
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }  
    }//GEN-LAST:event_actionSaveDeviceSettingsBlock

    /**
     * This method saves the device settings as text file.
     * @param evt 
     */
    private void actionSaveDeviceSettings(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveDeviceSettings
    {//GEN-HEADEREND:event_actionSaveDeviceSettings
        if (!this.executingCommand)
        {
            jTextAreaOutput.removeAll();
            this.executeCommand(Command.CommandType.COMMAND_SAVEDEVICESETTINGSASTEXT, 
                                "Save device settings as text file...", settings.getLogPath());
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        } 
    }//GEN-LAST:event_actionSaveDeviceSettings

    /**
     * This method saves the heart rate log of selected track
     * @param evt 
     */
    private void actionSaveHeartrate(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionSaveHeartrate
    {//GEN-HEADEREND:event_actionSaveHeartrate
        if (!this.executingCommand)
        {
            jTextAreaOutput.removeAll();
            saveHeartRate();
        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        } 
    }//GEN-LAST:event_actionSaveHeartrate

    /**
     * This method plots the heartrate in a graph
     * @param evt 
     */
    private void actionPlotHeartrate(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionPlotHeartrate
    {//GEN-HEADEREND:event_actionPlotHeartrate
        GraphFrame  frame;
        int         selection;
        String      resultString;
        List        heartRateLog;
        TrackLog    trackLog;

        jTextAreaOutput.removeAll();
        
        
        selection=jListTracks.getSelectedIndex();

        if (selection>=0)
        {
            trackLog=TrackLog.getInstance();
            
            heartRateLog=trackLog.getTrackHeartRateLog(selection);
            
            if ((heartRateLog!=null) || (heartRateLog.size()==0))
            {
            
                frame=new GraphFrame();
            
                resultString=frame.showTrackHeartRateLog("Track "+selection, heartRateLog);
                jTextAreaOutput.setText(resultString);
            }
        }
        else
        {
            jTextAreaOutput.setText("First, select a track...\n");
        }
    }//GEN-LAST:event_actionPlotHeartrate

    /**
     * This method deletes the uploadable route
     * @param evt 
     */
    private void actionDeleteRoute(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionDeleteRoute
    {//GEN-HEADEREND:event_actionDeleteRoute
       int      confirm;


        jTextAreaOutput.removeAll();

        if (!executingCommand)
        {
            confirm=JOptionPane.showConfirmDialog(mainPanel, 
                                                  "Are you sure to erase route from device?",
                                                  "Confirm erase",
                                                  JOptionPane.OK_CANCEL_OPTION);

            if (confirm==0)
            {
                this.executeCommand(Command.CommandType.COMMAND_ERASEROUTE, "Erasing route... Don't disconnect device!", null);
            }
            else
            {
                jTextAreaOutput.setText("Erasing canceled");
            }

        }
        else
        {
            jTextAreaOutput.setText("A command is being executed already, please wait\n");
        }        
    }//GEN-LAST:event_actionDeleteRoute

    private void actionQuit(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionQuit
    {//GEN-HEADEREND:event_actionQuit
        System.exit(0);
    }//GEN-LAST:event_actionQuit

    private void actionVerifyCacheFile(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionVerifyCacheFile
    {//GEN-HEADEREND:event_actionVerifyCacheFile
        this.executeCommand(Command.CommandType.COMMAND_VERIFYCACHEFILE, "Verifying cache file...", null);
    }//GEN-LAST:event_actionVerifyCacheFile

    private void actionShowSpeed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_actionShowSpeed
    {//GEN-HEADEREND:event_actionShowSpeed
        GraphFrame  frame;
        int         selection;
        String      resultString;
        List        trackLogPoints;
        TrackLog    trackLog;

        jTextAreaOutput.removeAll();
        
        
        selection=jListTracks.getSelectedIndex();

        if (selection>=0)
        {
            trackLog=TrackLog.getInstance();
            
//            trackLogPoints=trackLog.getTrackPoints(selection);
            
//            if ((trackLogPoints!=null) || (!trackLogPoints.isEmpty()))
//            {
            
                frame=new GraphFrame();
 

//                resultString=frame.showTrackSpeed("Track "+selection, trackLogPoints);
                resultString=frame.showTrackSpeed("Track "+selection, trackLog.getTrack(selection));
                jTextAreaOutput.setText(resultString);
//            }
        }
        else
        {
            jTextAreaOutput.setText("First, select a track...\n");
        }
    }//GEN-LAST:event_actionShowSpeed

    

    
    
    
    
    
    
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.ButtonGroup buttonGroup3;
    private javax.swing.JRadioButtonMenuItem csvMenuItem;
    private javax.swing.JRadioButtonMenuItem debugLevelDebugRadioButton;
    private javax.swing.JRadioButtonMenuItem debugLevelErrorRadioButton;
    private javax.swing.JRadioButtonMenuItem debugLevelInfoRadioButton;
    private javax.swing.JRadioButtonMenuItem debugLevelOffRadioButton;
    private javax.swing.JMenu debugMenu;
    private javax.swing.JRadioButtonMenuItem gpx1_0MenuItem;
    private javax.swing.JRadioButtonMenuItem gpx1_1MenuItem;
    private javax.swing.JRadioButtonMenuItem hybridMenuItem;
    private javax.swing.JButton jButtonDownloadTrack;
    private javax.swing.JButton jButtonEraseTracks;
    private javax.swing.JButton jButtonGetInfo;
    private javax.swing.JButton jButtonSaveRoute;
    private javax.swing.JButton jButtonSaveTrack;
    private javax.swing.JButton jButtonSaveWaypoints;
    private javax.swing.JButton jButtonShowRoute;
    private javax.swing.JButton jButtonShowTrack;
    private javax.swing.JButton jButtonShowWaypoints;
    private javax.swing.JButton jButtonUploadRoute;
    private javax.swing.JComboBox jComboBoxComport;
    private javax.swing.JLabel jLabelComport;
    private javax.swing.JLabel jLabelOutput;
    private javax.swing.JLabel jLabelProgress;
    private javax.swing.JLabel jLabelTracks;
    private javax.swing.JList jListTracks;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenu jMenuDevice;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenu jMenuHelp;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem5;
    private javax.swing.JMenuItem jMenuItem6;
    private javax.swing.JMenuItem jMenuItem7;
    private javax.swing.JMenuItem jMenuItemAbout;
    private javax.swing.JMenuItem jMenuItemDeleteRoute;
    private javax.swing.JMenuItem jMenuItemDownloadRoute;
    private javax.swing.JMenuItem jMenuItemDownloadTracks;
    private javax.swing.JMenuItem jMenuItemEraseTracks;
    private javax.swing.JMenuItem jMenuItemGetDeviceType;
    private javax.swing.JMenuItem jMenuItemGetInfo;
    private javax.swing.JMenu jMenuItemMapType;
    private javax.swing.JMenuItem jMenuItemOptions_SaveSettings;
    private javax.swing.JMenuItem jMenuItemRescanComports;
    private javax.swing.JMenuItem jMenuItemSaveDeviceLog;
    private javax.swing.JMenuItem jMenuItemSaveDeviceSettings;
    private javax.swing.JMenuItem jMenuItemSaveDeviceSettingsBlock;
    private javax.swing.JMenuItem jMenuItemSaveSimSet;
    private javax.swing.JMenuItem jMenuItemSaveTracks;
    private javax.swing.JMenuItem jMenuItemShowRoute;
    private javax.swing.JMenuItem jMenuItemShowSpeed;
    private javax.swing.JMenuItem jMenuItemShowWaypoints;
    private javax.swing.JMenuItem jMenuItemUploadRoute;
    private javax.swing.JMenu jMenuOptions;
    private javax.swing.JMenu jMenuOptions_FileOutputType;
    private javax.swing.JMenu jMenuRoutes;
    private javax.swing.JMenu jMenuTracks;
    private javax.swing.JMenu jMenuWaypoints;
    private javax.swing.JProgressBar jProgressBarDownload;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTextAreaOutput;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuItem menuItemVerifyCacheFile;
    private javax.swing.JRadioButtonMenuItem roadMenuItem;
    private javax.swing.JRadioButtonMenuItem satelliteMenuItem;
    private javax.swing.JRadioButtonMenuItem tcxMenuItem;
    private javax.swing.JRadioButtonMenuItem terrainMenuItem;
    // End of variables declaration//GEN-END:variables

    
    private JDialog aboutBox;
    
    
    /* ************************************************************************\
     * Functional variables
    \* ************************************************************************/

    private IgotuWriter             writer;
    
    private FileNameExtensionFilter gpxFileFilter;
    private FileNameExtensionFilter tcxFileFilter;
    private FileNameExtensionFilter csvFileFilter;
    
    private DefaultListModel        trackListModel;
    private CommunicationProcess    process;
    private boolean                 executingCommand;
    private Command                 command;
    private Settings                settings;

    private BitmapPane              bitmapPane;
    
    private int                     nextAfterWaypointDownload;
    private static final int        NEXTAFTERWAYPOINTDOWNLOAD_SAVE=1;
    private static final int        NEXTAFTERWAYPOINTDOWNLOAD_SHOW=2;

    private int                     nextAfterRouteDownload;
    private static final int        NEXTAFTERROUTEDOWNLOAD_SAVE=1;
    private static final int        NEXTAFTERROUTEDOWNLOAD_SHOW=2;


}
