/*
 * Igotu2gpx2App.java
 */

package net.deepocean.u_gotme;

import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.ResourceMap;

import java.awt.Image;

import javax.swing.JFrame;
import javax.swing.ImageIcon;

import java.util.ArrayList;


/**
 * The main class of the application.
 */
public class UgotmeApp extends SingleFrameApplication 
{

    /**
     * At startup create and show the main frame of the application.
     */
    @Override protected void startup() 
    {
        UgotmeView          view;
        Settings            settings;
        JFrame              mainFrame;
        ArrayList<Image>    iconList;
        ImageIcon           icon;        

        settings=Settings.getInstance();
        DebugLogger.setDebugLevel(settings.getDebugLevel());


// New frame based view
        view=new UgotmeView();
        view.setVisible(true);

        
        // Set the icons...
        ResourceMap resourceMap;
        resourceMap=this.getMainView().getResourceMap();
        System.out.println("Resource Dir "+resourceMap.getResourcesDir());
        
        iconList=new ArrayList();

        icon=resourceMap.getImageIcon("Application.icon16");
        iconList.add(icon.getImage());
        icon=resourceMap.getImageIcon("Application.icon24");
        iconList.add(icon.getImage());
        icon=resourceMap.getImageIcon("Application.icon32");
        iconList.add(icon.getImage());
        icon=resourceMap.getImageIcon("Application.icon42");
        iconList.add(icon.getImage());


        view.setIconImages(iconList);        
        
        
        

    }

    /**
     * This method is to initialize the specified window by injecting resources.
     * Windows shown in our application come fully initialized from the GUI
     * builder, so this additional configuration is not needed.
     */
    @Override protected void configureWindow(java.awt.Window root) 
    {
        ArrayList<Image>   iconList;
        ImageIcon       icon;
        
        
        ResourceMap resourceMap;
        resourceMap=this.getMainView().getResourceMap();
        System.out.println("Resource Dir "+resourceMap.getResourcesDir());
        
        iconList=new ArrayList();

        icon=resourceMap.getImageIcon("Application.icon16");
        iconList.add(icon.getImage());
        icon=resourceMap.getImageIcon("Application.icon24");
        iconList.add(icon.getImage());
        icon=resourceMap.getImageIcon("Application.icon32");
        iconList.add(icon.getImage());
        icon=resourceMap.getImageIcon("Application.icon42");
        iconList.add(icon.getImage());


        this.getMainFrame().setIconImages(iconList);


    }

    /**
     * A convenient static getter for the application instance.
     * @return the instance of Igotu2gpx2App
     */
    public static UgotmeApp getApplication() 
    {
        return Application.getInstance(UgotmeApp.class);
    }

    /**
     * Main method launching the application.
     */
    public static void main(String[] args) 
    {
        launch(UgotmeApp.class, args);
    }
}
