/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.TimeZone;


/**
 *
 * @author UserXP
 */
public class ToolBox
{
    /**
     * This function converts the 5 bytes in the device data that encode
     * the timestamp to a DateTime (UTC) timestamp
     * @param byte0 1st byte
     * @param byte1 2nd byte
     * @param byte2 3rd byte
     * @param byte3 4th byte
     * @param byte4 5th byte
     * @return The datetime stamp
     */
    public static DateTime bytesToDateTime(byte byte0, byte byte1, byte byte2, byte byte3, byte byte4)
    {
        DateTime    dateTime;
        DateTime    now;
        int         yearNow;
        int         yearMod16;

        int         year;
        int         month;
        int         day;
        int         hour;
        int         minute;
        int         second;
        int         nanosecond;


        // The year is tricky: in the device it actually is (year%16)
        // Assumption: the actual year logged is equal to or smaller than
        // current year.
        // So do some nifty calculation to get the most likely year the
        // data was logged.
        // Goes wrong if log time is longer that about 16 years ago ;-)
        // Given data retention of flash of 10 years, this is acceptable ;-)
        // It is more accurate to take the entire timestamp into account
        // i.s.o. just the year, but this would make the code more complex.
        // This is a good approximation
        now = DateTime.now(TimeZone.getTimeZone("GMT"));
        yearNow=now.getYear();

        yearMod16=(byte0>>4)&0x0f; // the logged year%16

        // If yearNow%16 >= yearMod16, everything is ok
        if((yearNow%16)>=yearMod16)
        {
            year=yearNow-(yearNow%16)+yearMod16;
        }
        else
        {
            year=yearNow-16-(yearNow%16)+yearMod16;
        }


        month=byte0&0x0f;
        day=(byte1>>3)&0x1f;
        hour=(byte1&0x07)*4+((byte2>>6)&0x3);
        minute=(byte2&0x3f);

        // This is the correct time stamp
        // Usually the seconds fraction is 0, however, sometimes a few milliseconds
        second=(((byte3&0xff)<<8)|(byte4&0xff))/1000;
        nanosecond=((((byte3&0xff)<<8)|(byte4&0xff))%1000)*1000000;

/*        
        dateTime=new DateTime(year, month, day, hour, minute, second, nanosecond);
*/

        // Set and round date time 
        dateTime=new DateTime(year, month, day, hour, minute, second, 0);
        if (nanosecond>500000000)
        {
            // add 1 second
            dateTime=dateTime.plus(0, 0, 0, 0, 0, 1, DateTime.DayOverflow.Abort);
        }
        
        
        
        return dateTime;
    }
    
    /**
     * This method converts a UTC datetime to the local time of the
     * computer.
     * @param utcDateTime The datetime stamp in UTC
     * @return The datetime stamp in local time
     */
    public static DateTime convertUtcToLocal(DateTime utcDateTime)
    {
        DateTime gmtTime;
        DateTime localTime;
        TimeZone gmtTimeZone;
        TimeZone localTimeZone;

        gmtTimeZone=TimeZone.getTimeZone("GMT");
        localTimeZone=TimeZone.getDefault();


       localTime=utcDateTime.changeTimeZone(gmtTimeZone, localTimeZone);

        return localTime;
    }

    /**
     * This method converts a number of bytes to an integer, assuming little
     * endian.
     * @param array  Array containing the bytes
     * @param offset Offset in the array
     * @param length Number of bytes to convert
     * @return The integer
     */
    public static int bytesToIntLe(byte[] array, int offset, int length)
    {
        int theInt;
        int i;
       
        theInt=0; 
        
        if (length==2)
        {
            theInt=java.nio.ByteBuffer.wrap(array, offset, length).order(java.nio.ByteOrder.LITTLE_ENDIAN).getShort();
        }
        else if (length==4)
        {
            theInt=java.nio.ByteBuffer.wrap(array, offset, length).order(java.nio.ByteOrder.LITTLE_ENDIAN).getInt();
        }
        
            
        return theInt;
    }
    
    /**
     * This method copies part of a source array to the destination array.
     * Note that this method does not allocate the destination.
     * @param source Source array
     * @param dest Destination array
     * @param offset Offset in the source array
     * @param length Bytes no copy
     */
    public static void copyBytes(byte[] source, byte[] dest, int offset, int length)
    {
        int i;
        
        i=0;
        while (i<length)
        {
            dest[i]=source[i+offset];
            i++;
        }
    }

}
