/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

import hirondelle.date4j.DateTime;

/**
 *
 * @author Jorgen
 */
public class TcxWriter implements IgotuWriter
{
    private static TcxWriter    theInstance=null;

    private TrackLog            trackLog;
    private WaypointLog         waypointLog;
    private RouteLog            routeLog;
    private int                 trackPoints;
    private int                 wayPoints;
    private String              gpxVersion;
    
    Document                    doc;
    Element                     tcxElement;    
    /**
     * Constructor
     */
    private TcxWriter()
    {
        trackLog        =TrackLog.getInstance();
        waypointLog     =WaypointLog.getInstance();
        routeLog        =RouteLog.getInstance();
    }    
    
    /**
     * This method returns the one and only instance of this singleton class
     * @return The instance
     */
    public static TcxWriter getInstance()
    {
        if (theInstance==null)
        {
            theInstance=new TcxWriter();
        }

        return theInstance;
    }    
    
    
    /**
     * This method creates the XML document, adds the TCX headers and
     * creates the <TrainingCenterDatabase> element. 
     * The variables doc and gpxElement will be global variables in this class.
     * @throws javax.xml.parsers.ParserConfigurationException
     */
    private void createGpxDocument(Device.DeviceType deviceType) throws ParserConfigurationException
    {
        String      creator;


        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

        // The document
        doc = docBuilder.newDocument();


        // tcx elements
        tcxElement = doc.createElement("TrainingCenterDatabase");
        doc.appendChild(tcxElement);


        creator=new String("u-gotMe - ")+
        Device.getDeviceTypeDescription(deviceType);
        this.addTcxHeader(doc, tcxElement, creator);

    }

    /**
     * This method writes the TCX file
     * @param fileName Name of the file
     * @throws javax.xml.transform.TransformerException
     */
    void writeTcxDocument(String fileName) throws TransformerException
    {
            // write the content into xml file
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);

            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");


            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(fileName));


            transformer.transform(source, result);
    }
    
    /**
     * Add the TCX 2.0 header
     * @param doc The XML document
     * @param gpxElement The TCX element
     */
    private void addTcxHeader(Document doc, Element tcxElement, String creator)
    {
        Attr        attr;

        // TCX namespace
        attr = doc.createAttribute("xmlns");
        attr.setValue("http://www.garmin.com/xmlschemas/TrainingCenterDatabase/v2");
        tcxElement.setAttributeNode(attr);

        // XMLSchema namespace
        attr = doc.createAttribute("xmlns:xsi");
        attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
        tcxElement.setAttributeNode(attr);

         // Schema locations - just the TCX location
        attr = doc.createAttribute("xsi:schemaLocation");
        attr.setValue("http://www.garmin.com/xmlschemas/TrainingCenterDatabase/v2 http://www.garmin.com/xmlschemas/TrainingCenterDatabasev2.xsd");
        tcxElement.setAttributeNode(attr);

    }

    
    /**
     * Appends the track points to the Track element. 
     * @param doc The document
     * @param trackElement Document element representing the track 
     * @param trackNo The track
     * @param segmentNo The segment
     */
    private void appendTrackTcx(Document doc, Element trackElement, int trackNo, int segmentNo)
    {
        ArrayList <TrackLogPoint>   points;
        Iterator<TrackLogPoint>     iterator;
        TrackLogPoint               point;
        Element                     pointElement;
        Element                     positionElement;
        Element                     heartRateElement;
        Element                     element;
        int                         heartRate;
        Attr                        attr;
        DateTime                    dateTime;
        String                      dateTimeString;


        points=trackLog.getTrackPoints(trackNo, segmentNo);

        iterator=points.iterator();

        while (iterator.hasNext())
        {
            point           =iterator.next();
            pointElement    = doc.createElement("Trackpoint");
            trackElement.appendChild(pointElement);

            element    = doc.createElement("Time");
            dateTime=point.getDateTime();
            dateTimeString=dateTime.format("YYYY-MM-DD")+"T"+
                           dateTime.format("hh:mm:ss")+"Z";
            element.appendChild(doc.createTextNode(dateTimeString));
            pointElement.appendChild(element);
            
            
            positionElement    = doc.createElement("Position");
            pointElement.appendChild(positionElement);

            element    = doc.createElement("LatitudeDegrees");
            element.appendChild(doc.createTextNode(String.valueOf(point.getLatitude())));
            positionElement.appendChild(element);
            
            element    = doc.createElement("LongitudeDegrees");
            element.appendChild(doc.createTextNode(String.valueOf(point.getLongitude())));
            positionElement.appendChild(element);
            
            element    = doc.createElement("AltitudeMeters");
            element.appendChild(doc.createTextNode(String.valueOf(point.getElevation())));
            pointElement.appendChild(element);

            element    = doc.createElement("DistanceMeters");
            element.appendChild(doc.createTextNode(String.valueOf(point.getElevation())));
            pointElement.appendChild(element);
            
            heartRate=point.getHeartRate();
            if (heartRate>0)
            {
                heartRateElement = doc.createElement("HeartRateBpm");
                pointElement.appendChild(heartRateElement);
                attr = doc.createAttribute("xsi:type");
                attr.setValue("HeartRateInBeatsPerMinute_t");
                heartRateElement.setAttributeNode(attr);
                element = doc.createElement("Value");
                element.appendChild(doc.createTextNode(Long.toString(heartRate)));
                heartRateElement.appendChild(element);
            }    

            trackPoints++;

        }
    }
    
    
    /**
     * This method adds the track segments to the track.
     * @param doc XML document
     * @param gpxElement The GPX element
     * @param trackNo The track identification
     * @param trackName The track name
     */
    private void addTrack(Document doc, Element gpxElement, int trackNo, String trackName)
    {
        int      i;
        int      numberOfSegments;
        Track    track;
        Element  foldersElement;
        Element  activitiesElement;
        Element  activityElement;
        Element  heartRateElement;
        Element  idElement;
        Element  lapElement;
        Element  trackElement;
        Element  element;
        Attr     attr;
        DateTime dateTime;
        String   dateTimeString;
        long     heartRate;
        long     kCal;

        track=trackLog.getTrack(trackNo);
        numberOfSegments=trackLog.getNumberOfTrackSegments(trackNo);

        // The folders element
        foldersElement = doc.createElement("Folders");
        gpxElement.appendChild(foldersElement);
        
        // The Activities element
        activitiesElement = doc.createElement("Activities");
        gpxElement.appendChild(activitiesElement);
        
        // The Activity element
        activityElement = doc.createElement("Activity");
        activitiesElement.appendChild(activityElement);
        attr = doc.createAttribute("Sport");
        attr.setValue("Other");
        activityElement.setAttributeNode(attr);
        
        // The Id element
        dateTime=trackLog.getTrackStartTime(trackNo);
        dateTimeString=dateTime.format("YYYY-MM-DD")+"T"+
                       dateTime.format("hh:mm:ss")+"Z";

        idElement = doc.createElement("Id");
        idElement.appendChild(doc.createTextNode(dateTimeString));
        activityElement.appendChild(idElement);
        
        // The Lap element
        lapElement = doc.createElement("Lap");
        attr = doc.createAttribute("StartTime");
        attr.setValue(dateTimeString);
        lapElement.setAttributeNode(attr);        
        activityElement.appendChild(lapElement);


        element = doc.createElement("TotalTimeSeconds");
        element.appendChild(doc.createTextNode(Long.toString(track.getTotalTrackDuration())));
        lapElement.appendChild(element);
        
        element = doc.createElement("DistanceMeters");
        element.appendChild(doc.createTextNode(Double.toString(track.getTrackDistance())));
        lapElement.appendChild(element);
        
        element = doc.createElement("MaximumSpeed");
        element.appendChild(doc.createTextNode(Double.toString(track.getTrackMaxSpeed())));
        lapElement.appendChild(element);
        
        kCal=Math.round(track.getCalories());
        element = doc.createElement("Calories");
        element.appendChild(doc.createTextNode(Long.toString(kCal)));
        lapElement.appendChild(element);
        

        heartRate=Math.round(track.getAverageHeartRate());
        if (heartRate>0)
        {
            heartRateElement = doc.createElement("AverageHeartRateBpm");
            lapElement.appendChild(heartRateElement);
            attr = doc.createAttribute("xsi:type");
            attr.setValue("HeartRateInBeatsPerMinute_t");
            heartRateElement.setAttributeNode(attr);
            element = doc.createElement("Value");
            element.appendChild(doc.createTextNode(Long.toString(heartRate)));
            heartRateElement.appendChild(element);
        }        
        
        heartRate=track.getMaxHeartRate();
        if (heartRate>0)
        {
            heartRateElement = doc.createElement("MaximumHeartRateBpm");
            lapElement.appendChild(heartRateElement);
            attr = doc.createAttribute("xsi:type");
            attr.setValue("HeartRateInBeatsPerMinute_t");
            heartRateElement.setAttributeNode(attr);
            element = doc.createElement("Value");
            element.appendChild(doc.createTextNode(Long.toString(heartRate)));
            heartRateElement.appendChild(element);
        }        
        
        element = doc.createElement("Intensity");
        element.appendChild(doc.createTextNode("Active"));
        lapElement.appendChild(element);
        
        element = doc.createElement("TriggerMethod");
        element.appendChild(doc.createTextNode("Manual"));
        lapElement.appendChild(element);

        // The track element
        trackElement = doc.createElement("Track");
        lapElement.appendChild(trackElement);
       
        
        // Add the track segments.
        i=0;
        while (i<numberOfSegments)
        {
            // segment
            appendTrackTcx(doc, trackElement, trackNo, i);

            
            i++;
        }
    }    
    
    /**
     * This method writes the indicated track as stored in the TrackLog to file
     * @param fileName File name
     * @param trackNo Number of the track in the TrackLog
     * @param trackName Name of the track, can be used for identification
     */
    public void writeTrackToFile(String fileName, int trackNo, String trackName)
    {
        Element     trackElement;
        Element     element;
        Comment     comment;
        Attr        attr;
        String      creator;


        wayPoints=0;
        trackPoints=0;

        try
        {
            // create the GPX file
            createGpxDocument(trackLog.getDeviceType());


            addTrack(doc, tcxElement, trackNo, trackName);

            // write the content into xml file
            writeTcxDocument(fileName);

            DebugLogger.info("TcxWriter says: 'File saved to " + fileName + "!'");
            DebugLogger.info("Track: "+trackName+", track points: "+trackPoints+
                             ", wayPoints: "+wayPoints);

        }
        catch (ParserConfigurationException pce)
        {
            pce.printStackTrace();
        }
        catch (TransformerException tfe)
        {
            tfe.printStackTrace();
        }
        
    }

    /**
     * This method writes the waypoints in the WaypointLog to file
     * @param fileName The filename
     */
    public void writeWaypointsToFile(String fileName)
    {
        
    }

    /**
     * The method writes the route in the RouteLog to file
     * @param fileName The name of the file to write to
     */
    public void writeRouteToFile(String fileName)
    {
        
    }

    /**
     * The method writes the heartrate  of one track to file
     * @param fileName The name of the file to write to
     */
    public void writeHeartRateToFile(String fileName, int trackNo)
    {
        
    }
    
}
