/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.DataInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;

import java.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * This class respresents the repository of Symbols. Symbols are read from
 * the file symbols.txt
 * @author Jorgen
 */
public class SymbolRepository
{
    /** The filename */
    private static final String SYMBOLSFILE="symbols.txt";

    private static final String DELIMETER=";";

    private static final String COMMENTDELIMETER="#";

    /** The one and only instance reference */
    private static SymbolRepository theInstance=null;

    /** The repository   */
    private ArrayList<Symbol> symbols;

    /**
     * The private constructor. It reads the symbol definitions from file.
     */
    private SymbolRepository()
    {
        symbols=new ArrayList<Symbol>();
        readSymbols();
        if (symbols.size()==0)
        {
            DebugLogger.error("No symbols found!");
        }

    }

    /**
     * This method reads the symbol file
     */
    private void readSymbols()
    {
        FileInputStream     fstream;
        DataInputStream     in;
        BufferedReader      br;
        String              line;
        String[]            splitLine;
        StringTokenizer     tokenizer;

        int                 id;
        String              name;
        int[]               bitmap;
        Symbol              symbol;
        int                 i;
        String              token;

        // Empty the symbol array
        symbols.clear();
        try
        {
            // Open the file that is the first
            // command line parameter
            fstream = new FileInputStream(SYMBOLSFILE);

            // Get the object of DataInputStream
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));


            //Read File Line By Line
            while ((line = br.readLine()) != null)
            {
                // If it is not a comment
                if (!line.startsWith(COMMENTDELIMETER))
                {
                    // Remove appending comments
                    splitLine=line.split(COMMENTDELIMETER);
                    tokenizer=new StringTokenizer(splitLine[0], DELIMETER);
                    if (tokenizer.countTokens()==17)
                    {
                        // ID
                        token=tokenizer.nextToken().trim();
                        id=Integer.parseInt(token);

                        // Name
                        name=tokenizer.nextToken().trim();

                        // Bitmap
                        bitmap=new int[15];
                        i=0;
                        while (i<15)
                        {
                            token=tokenizer.nextToken().trim();
                            bitmap[i]=Integer.parseInt(token,16);
                            i++;
                        }
                        symbol=new Symbol(id, name, bitmap);
                        symbols.add(symbol);
                    }

                }
            }

            //Close the input stream
            in.close();
        }
        catch (IOException e)
        {//Catch exception if any
            DebugLogger.error("Error reading symbols file "+SYMBOLSFILE);
        }
    }

    /**
     * This method returns the one and only Singleton instance of this class.
     * @return
     */
    public static SymbolRepository getInstance()
    {
        if (theInstance==null)
        {
            theInstance=new SymbolRepository();
        }

        return theInstance;
    }

    /**
     * This method returns a byte array containing a symbol bitmap.
     * The bitmap is 15x15 pixels. 15 bytes are returned in the array.
     * @param symbolName
     * @return
     */
    public int[] getSymbolBitmap(String symbolName)
    {
        int[]               symbolBitmap;
        Iterator<Symbol>    i;
        boolean             found;
        Symbol              symbol;

        symbolBitmap=null;

        i=symbols.iterator();
        found=false;
        while (i.hasNext() && !found)
        {
            symbol=i.next();
            if (symbol.getName().toLowerCase().equals(symbolName.toLowerCase()))
            {
                found=true;
                symbolBitmap=symbol.getBitmap();
            }
        }

        if (!found)
        {
            if (symbols.size()>0)
            {
                symbol=symbols.get(0);
                symbolBitmap=symbol.getBitmap();
            }
            else
            {
            }
        }

        return symbolBitmap;
    }

    /**
     * This method returns the symbol name, given the ID of the symbol
     * @param id The ID (0-255)
     * @return The name or the name corresponding to symbol[0] if symbol
     *         not found
     */
    public String getSymbolNameById(int id)
    {
        String              symbolName;
        Iterator<Symbol>    i;
        boolean             found;
        Symbol              symbol;

        symbolName="";

        i=symbols.iterator();
        found=false;
        while (i.hasNext() && !found)
        {
            symbol=i.next();
            if (symbol.getId()==id)
            {
                found=true;
                symbolName=symbol.getName();
            }
        }

        return symbolName;
    }

    /**
     * This method returns the symbol name, given the ID of the symbol
     * @param name Name of the symbol to look for
     * @return The ID of the symbol or 0x00 if not found
     */
    public int getSymbolIdByName(String name)
    {
        int                 id;
        Iterator<Symbol>    i;
        boolean             found;
        Symbol              symbol;

        id=0;

        i=symbols.iterator();
        found=false;
        while (i.hasNext() && !found)
        {
            symbol=i.next();
            if (symbol.getName().toLowerCase().equals(name.toLowerCase().trim()))
            {
                found=true;
                id=symbol.getId();
            }
        }

        return id;
    }


}
