/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

/**
 *
 * @author UserXP
 */
public class Symbol
{
    public static final int     SYMBOL_BYTES=15;

    private int                 id;
    private String              name;
    private int[]               bitmap;

    /**
     * Constructor. Creates and initialises the symbol
     * @param id Id of the symbol (0-255)
     * @param name Name of the symbol. Max 15 chars
     * @param bitmap Bitmap (array of 15 ints)
     */
    public Symbol(int id, String name, int[] bitmap)
    {
        if ((id<0) || (id>255))
        {
            DebugLogger.error("Symbol id out of range");
        }
        this.id     =id;
        this.name   =name;
        this.bitmap =bitmap;
    }

    /**
     * This method returns the name of the Symbol
     * @return The name
     */
    public String getName()
    {
        return name;
    }

    /**
     * This method returns the ID of the symbol
     * @return The ID
     */
    public int getId()
    {
        return id;
    }

    /**
     * This method returns the bitmap
     * @return The bitmap, array of SYMBOL_BYTES ints.
     */
    public int[] getBitmap()
    {
        return bitmap;
    }
}
