/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import java.util.ArrayList;
import java.util.Iterator;




/**
 *
 * @author UserXP
 */
public class RouteLog
{
    /** The one and only singleton instance of this class. */
    private static RouteLog         theInstance=null;

    private ArrayList<RoutePoint>   theLog;

    private Device.DeviceType      deviceType;
    
    private static int              nextRoutePointNumber;

    /** The private constructor */
    private RouteLog()
    {
        theLog              =new ArrayList<RoutePoint>();
        deviceType          =Device.DeviceType.DEVICETYPE_UNKNOWN;
        clear();
    }

    /**
     * This method returns the one and only instance of this singleton class.
     * @return The instance
     */
    public static RouteLog getInstance()
    {
        if (theInstance==null)
        {
            theInstance=new RouteLog();
        }
        return theInstance;
    }

    /**
     * This method clears the Route log
     */
    public void clear()
    {
        theLog.clear();
        nextRoutePointNumber=1;
    }

    /**
     * This method parses the data and translates it to waypoints
     * @param data The data
     * @param length The size of the data. Multiple of 0x120
     * @return False if the end of the waypoints is found, true if not.
     */
    public boolean appendData(byte[] data, int length)
    {
/*
        boolean         hasMoreData;
        int             count;
        int             maxCount;
        int             j;
        int             start;
        int             longitude;
        int             latitude;
        int             elevation;
        int             offset;
        RouteWaypoint   point;
        byte[]          bitmap;


        if (length%RouteWaypoint.ROUTEWAYPOINT_RECORDSIZE!=0)
        {
            DebugLogger.error("Route Waypoint data has invalid length");
        }



        hasMoreData =true;
        count       =0;
        maxCount    =length/RouteWaypoint.ROUTEWAYPOINT_RECORDSIZE;
        while (hasMoreData && count<maxCount)
        {
            offset=RouteWaypoint.ROUTEWAYPOINT_RECORDSIZE*count;
            start=((data[offset+0]&0xff))+
                  ((data[offset+1]&0xff)<<8)+
                  ((data[offset+2]&0xff)<<16)+
                  ((data[offset+3]&0xff)<<24);

            if (start==0x022048B8)
            {
                latitude =((data[offset+ 4]&0xff))+
                          ((data[offset+ 5]&0xff)<<8)+
                          ((data[offset+ 6]&0xff)<<16)+
                          ((data[offset+ 7])<<24);
                longitude=((data[offset+ 8]&0xff))+
                          ((data[offset+ 9]&0xff)<<8)+
                          ((data[offset+10]&0xff)<<16)+
                          ((data[offset+11])<<24);
                elevation=((data[offset+12]&0xff))+
                          ((data[offset+13]&0xff)<<8)+
                          ((data[offset+14]&0xff)<<16)+
                          ((data[offset+15])<<24);

                // create bitmap
                bitmap=new byte[RouteWaypoint.BITMAP_SIZE];

                // Copy the bitmap
                j=0;
                while (j<RouteWaypoint.BITMAP_SIZE)
                {
                    bitmap[j]=data[offset+32+j];
                    j++;
                }

                point=new RouteWaypoint(longitude, latitude, elevation, bitmap);
                theLog.add(point);

                count++;
            }
            else
            {
                hasMoreData=false;
            }
        }

        return hasMoreData;
*/
        boolean         hasMoreData;
        int             count;
        int             maxCount;
        int             start;
        int             offset;
        RoutePoint   point;
        byte[]          bitmap;
        byte[]          theData;
        int             i;


        theData=new byte[RoutePoint.ROUTEPOINT_RECORDSIZE];

        if (length%RoutePoint.ROUTEPOINT_RECORDSIZE!=0)
        {
            DebugLogger.error("Route Waypoint data has invalid length");
        }



        hasMoreData =true;
        count       =0;
        maxCount    =length/RoutePoint.ROUTEPOINT_RECORDSIZE;
        while (hasMoreData && count<maxCount)
        {
            offset=RoutePoint.ROUTEPOINT_RECORDSIZE*count;
            start=((data[offset+0]&0xff))+
                  ((data[offset+1]&0xff)<<8)+
                  ((data[offset+2]&0xff)<<16)+
                  ((data[offset+3]&0xff)<<24);

            // If the data contains the start sequence...
            if (start==0x022048B8)
            {
                // Copy the record data
                i=0;
                while (i<RoutePoint.ROUTEPOINT_RECORDSIZE)
                {
                    theData[i]=data[offset+i];
                    i++;
                }

                // Create a route waypoint from it and store it
                point=new RoutePoint(theData, nextRoutePointNumber);
                theLog.add(point);
                nextRoutePointNumber++;

                count++;
            }
            else
            {
                hasMoreData=false;
            }
        }

        return hasMoreData;


    }

    /**
     * This method appends a waypoint to the log
     * @param waypoint The waypoint to add
     */
    public void appendWaypoint(RoutePoint waypoint)
    {
        this.theLog.add(waypoint);
    }

    /**
     * Return the number of entries in the log
     * @return The number of entries
     */
    public int getNumberOfEntries()
    {
        return theLog.size();
    }

    /**
     * Print an overview of the log to the DebugLogger
     */
    public void dumpLog()
    {
        Iterator<RoutePoint>  e;
        RoutePoint            point;

        e=theLog.iterator();

        while (e.hasNext())
        {
            point=e.next();
            DebugLogger.info(point.toString());
        }
    }

    /**
     * This method returns the Vector with waypoints that make up the route.
     * @return The Vector with waypoints.
     */
    public ArrayList<RoutePoint> getWaypoints()
    {
        return this.theLog;
    }

    /**
     * This method returns a waypoint as byte array in the format the Device
     * expects it
     * @param index Index of the waypoint
     * @return The byte array or null if the index is not valid
     */
    public byte[] getWaypointAsByteArray(int index)
    {
        byte[] record;

        if (index<theLog.size())
        {
            record=theLog.get(index).getRecordAsByteArray();
        }
        else
        {
            record=null;
        }
        return record;
    }

    /**
     * This method sets the type of the device from which the route
     * originates. Set to DEVICETYPE_UNKNOWN if it does not originate from a
     * device
     * @param deviceType The device type as defined in Device
     */
    public void setDeviceType(Device.DeviceType deviceType)
    {
        this.deviceType=deviceType;
    }

    /**
     * Returns the type of the device from which the route originated
     * @return The device type
     */
    public Device.DeviceType getDeviceType()
    {
        return this.deviceType;
    }

}
