/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

/**
 *
 * @author Jorgen
 */
public class MemoryMapGT820GT900 extends MemoryMap
{
    // Default memory map: applies to GT-800, GT-800pro, GT-820pro, GT-900pro
    private final int       FLASH_STARTADDRESS      =0x000000;
    private final int       FLASH_PAGES             =0x800;
    
    private final int       SETTINGS_STARTADDRESS   =0x000000;
    
    private final int       TRACK_STARTADDRESS      =0x001000;
    private final int       TRACK_PAGES             =0x700-0x001;
    private final int       TRACK_FIRSTPAGE         =0x001;
    private final int       TRACK_LASTPAGE          =0x6FF;
    private final int       MAX_TRACKPOINTS         =229248; //0x37f80 = (0x700-0x001)*0x1000/0x20
    
    
    private final int       ROUTE_STARTADDRESS      =0x707000;
    private final int       ROUTE_BLOCKS            =0x08;
    private final int       ROUTE_MAXWAYPOINTS      =100;

    private final int      WAYPOINTS_STARTADDRESS   =0x700000;
    private final int      WAYPOINTS_BLOCKS         =0x07;    
    
    
    private final boolean  ISTRACKSSUPPORTED        =true;
    private final boolean  ISWAYPOINTSSUPPORTED     =true;
    private final boolean  ISROUTESUPPORTED         =true;
    
    private final boolean  ISVALIDMEMORYMAP         =false;
    
    
    @Override
    public int getFlashStartAddress()
    {
        return FLASH_STARTADDRESS;
    }
    
    @Override
    public int getFlashPages()
    {
        return FLASH_PAGES;
    }
    
    @Override
    public int getSettingsStartAddress()
    {
        return SETTINGS_STARTADDRESS;
    }
    
    @Override
    public int getTracksStartAddress()
    {
        return TRACK_STARTADDRESS;
    }
    
    @Override
    public int getTracksPages()
    {
        return TRACK_PAGES;
    }

    @Override
    public int getTracksFirstPage()
    {
        return TRACK_FIRSTPAGE;
    }
    
    @Override
    public int getTracksLastPage()
    {
        return TRACK_LASTPAGE;
    }
    
    @Override
    public int getTracksMaxRecords()
    {
        return MAX_TRACKPOINTS;
    }
    
    @Override
    public int getRouteStartAddress()
    {
        return ROUTE_STARTADDRESS;
    }
    
    @Override
    public int getRoutePages()
    {
        return ROUTE_BLOCKS;
    }
    
    @Override
    public int getRouteMaxWaypoints()
    {
        return ROUTE_MAXWAYPOINTS;
    }
    
    @Override
    public int getWaypointsStartAddress()
    {
        return WAYPOINTS_STARTADDRESS;
    }
    
    @Override
    public int getWaypointsPages()
    {
        return WAYPOINTS_BLOCKS;
    }
    
    /**
     * Indicates if the device supports the tracklog
     * @return True if it supports track logging, false if not
     */
    @Override
    public boolean isTrackSupported()
    {
        return ISTRACKSSUPPORTED;
    }
    
    /**
     * Indicates if the device supports the dedicated way point log area
     * @return True if it supports way point logging, false if not
     */
    @Override
    public boolean isWaypointsSupported()
    {
        return ISWAYPOINTSSUPPORTED;
    }
    
    /**
     * Indicates if the device supports the dedicated route area
     * @return True if it supports storage of a route, false if not
     */
    @Override
    public boolean isRouteSupported()
    {
        return ISROUTESUPPORTED;
    }      

    /**
     * Returns if this memory map can be used
     * @return True if valid, false if not
     */
    @Override
    public boolean isValidMemoryMap()
    {
        return this.ISVALIDMEMORYMAP;
    }       
}
