/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

/**
 *
 * @author Jorgen
 */
public class MemoryMap 
{
    // Empty memory map
    private final int       FLASH_STARTADDRESS      =0x000000;
    private final int       FLASH_PAGES             =0x000;
    
    private final int       SETTINGS_STARTADDRESS   =0x000000;
    
    private final int       TRACK_STARTADDRESS      =0x000000;
    private final int       TRACK_PAGES             =0x000;
    private final int       TRACK_FIRSTPAGE         =0x000;
    private final int       TRACK_LASTPAGE          =0x000;
    private final int       MAX_TRACKPOINTS         =/*229248*/00;
    
    
    private final int       ROUTE_STARTADDRESS      =0x000000;
    private final int       ROUTE_BLOCKS            =0x00;
    private final int       ROUTE_MAXWAYPOINTS      =0;

    private final int      WAYPOINTS_STARTADDRESS   =0x000000;
    private final int      WAYPOINTS_BLOCKS         =0x00;  
    
    private final boolean  ISTRACKSSUPPORTED        =false;
    private final boolean  ISWAYPOINTSSUPPORTED     =false;
    private final boolean  ISROUTESUPPORTED         =false;
    private final boolean  ISSCHEDULESSUPPORTED     =false;
    private final boolean  ISNMEASUPPORTED          =false;
    
    
    private final boolean  ISVALIDMEMORYMAP         =false;
    
    
     public int getFlashStartAddress()
    {
        return FLASH_STARTADDRESS;
    }
    
    public int getFlashPages()
    {
        return FLASH_PAGES;
    }
    
    public int getSettingsStartAddress()
    {
        return SETTINGS_STARTADDRESS;
    }
    
    public int getTracksStartAddress()
    {
        return TRACK_STARTADDRESS;
    }
    
    public int getTracksPages()
    {
        return TRACK_PAGES;
    }
    
    public int getTracksFirstPage()
    {
        return TRACK_FIRSTPAGE;
    }
    
    public int getTracksLastPage()
    {
        return TRACK_LASTPAGE;
    }
    
    public int getTracksMaxRecords()
    {
        return MAX_TRACKPOINTS;
    }
    
    public int getRouteStartAddress()
    {
        return ROUTE_STARTADDRESS;
    }
    
    public int getRoutePages()
    {
        return ROUTE_BLOCKS;
    }
    
    public int getRouteMaxWaypoints()
    {
        return ROUTE_MAXWAYPOINTS;
    }
    
    public int getWaypointsStartAddress()
    {
        return WAYPOINTS_STARTADDRESS;
    }
    
    public int getWaypointsPages()
    {
        return WAYPOINTS_BLOCKS;
    }
    
    /**
     * Indicates if the device supports the tracklog
     * @return True if it supports track logging, false if not
     */
    public boolean isTrackSupported()
    {
        return ISTRACKSSUPPORTED;
    }
    
    /**
     * Indicates if the device supports the dedicated way point log area
     * @return True if it supports way point logging, false if not
     */
    public boolean isWaypointsSupported()
    {
        return ISWAYPOINTSSUPPORTED;
    }
    
    /**
     * Indicates if the device supports the dedicated route area
     * @return True if it supports storage of a route, false if not
     */
    public boolean isRouteSupported()
    {
        return ISROUTESUPPORTED;
    }    
    
    /**
     * Returns if this device supports schedules
     * @return True if schedules are supported, false if not
     */
    public boolean isSchedulesSupported()
    {
        return this.ISSCHEDULESSUPPORTED;
    }
    
    /**
     * Returns if this device supports NMEA dongle mode
     * @return True if NMEA donlge mode issupported, false if not
     */
    public boolean isNmeaSupoorted()
    {
        return this.ISNMEASUPPORTED;
    }
    
    /**
     * Returns if this memory map can be used
     * @return True if valid, false if not
     */
    public boolean isValidMemoryMap()
    {
        return this.ISVALIDMEMORYMAP;
    }
    
}
