/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

/**
 *
 * @author UserXP
 */
public interface IgotuWriter
{
    /**
     * This method writes the indicated track as stored in the TrackLog to file
     * @param fileName File name
     * @param trackNo Number of the track in the TrackLog
     * @param trackName Name of the track, can be used for identification
     */
    public void writeTrackToFile(String fileName, int trackNo, String trackName);

    /**
     * This method writes the waypoints in the WaypointLog to file
     * @param fileName The filename
     */
    public void writeWaypointsToFile(String fileName);


    /**
     * The method writes the route in the RouteLog to file
     * @param fileName The name of the file to write to
     */
    public void writeRouteToFile(String fileName);


    /**
     * The method writes the heartrate  of one track to file
     * @param fileName The name of the file to write to
     */
    public void writeHeartRateToFile(String fileName, int trackNo);

}
