/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.TimeZone;
import java.util.ArrayList;

/**
 * This class represents one heart rate reading
 * @author Jorgen
 */
public class HeartRatePoint 
{
    /** Date time of the reading in UTC */
    DateTime dateTime;
    
    /** The reading in BPM */
    int heartRate;

    /**
     * The constructor. It is private, so it can only be used from within
     * this class.
     * @param dateTime Date time stamp of the reading in UTC
     * @param heartRate The reading value in bpm
     */
    private HeartRatePoint(DateTime dateTime, int heartRate)
    {
        this.dateTime=dateTime;
        this.heartRate=heartRate;
    }
    
    /**
     * This method parses a I-gotU record and generates an array list of 
     * HeartRatePoint records.
     * @param record The record to parse containing 24 values
     * @return The array list with HeartRatePoints
     */
    public static ArrayList<HeartRatePoint> parseHeartRateRecord(byte[] record)
    {
        ArrayList<HeartRatePoint>   points;
        HeartRatePoint              point;
        DateTime                    dateTime;
        DateTime                    pointDateTime;
        int                         pointRate;
        int                         flags;
        DateTime                    now;
        int                         yearNow;
        int                         year;
        int                         yearMod16;
        int                         month;
        int                         day;
        int                         hour;
        int                         minute;
        int                         millis;
        int                         second;
        int                         millisecond;
        int                         i;

      
        points=new ArrayList<HeartRatePoint>();

        
        // Flags
        flags=record[0]&0xff;

        
        
        // Date and time
         dateTime=ToolBox.bytesToDateTime(record[1], record[2], record[3], record[4], record[5]);
       
        // flags=0xF5: the record is heartrate log
        if (flags==0xF5)
        {
            i=0;
            while (i<24)
            {
                pointDateTime=dateTime.minus(0, 0, 0, 0, 0, 23-i, DateTime.DayOverflow.Abort);
                pointRate=(record[6+i] & 0xff);
                
                
                point=new HeartRatePoint(pointDateTime, pointRate);
               
//System.out.println("Point "+pointDateTime.toString()+" "+pointRate);                
                points.add(point);
                
                i++;
            }
        }
        
        
        return points;
        
    }
    
    /**
     * This method returns the timestamp of the heart rate value;
     * @return The timestamp
     */
    public DateTime getDateTime()
    {
        return this.dateTime;
    }
    
    /**
     * This method returns the heart rate value
     * @return The heart rate value, or -1 if not available
     */
    public int getHeartRateValue()
    {
        int value;
        
        // The heart rate 0 does not make sense. Also 0xFF is invalid
        if ((this.heartRate==0) || (this.heartRate==255))
        {
            value=-1;
        }
        else
        {
            value=this.heartRate;
                    
        }

        return value;
    }
}
