/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;

import hirondelle.date4j.DateTime;


import java.util.List;
import java.util.ListIterator;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.DefaultShadowGenerator;

import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
//import org.jfree.ui.ApplicationFrame;
//import org.jfree.ui.RectangleInsets;
//import org.jfree.ui.RefineryUtilities;

import java.awt.Color;
import java.text.SimpleDateFormat;

import javax.swing.JPanel;


/**
 * This class shows the Heart Rate graph
 * @author Jorgen
 */
public class GraphFrame extends JFrame
{
    List<HeartRatePoint>    heartRateLog;
    String                  trackName;

    /**
     * Constuctor. Sets a default size
     */
    public GraphFrame()
    {
        this.setSize(800, 600);
        this.setResizable(false);
    }    
    
    
    
    /**
     * Creates a chart.
     *
     * @param dataset  A dataset. Or null to draw an empty chart.
     *
     * @return A chart.
     */
    private  JFreeChart createChart(XYDataset dataset) 
    {
        DateAxis  timeAxis;
        ValueAxis valueAxis;
       

        JFreeChart chart = ChartFactory.createTimeSeriesChart(
            "",                         // title
            "",                         // x-axis label
            "",                         // y-axis label
            dataset,                    // data
            false,                      // create legend?
            false,                      // generate tooltips?
            false                       // generate URLs?
        );

        chart.setBackgroundPaint(Color.white);

        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
//        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        
        plot.setShadowGenerator(new DefaultShadowGenerator());
        
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) 
        {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) r;
            renderer.setBaseShapesVisible(false);
            renderer.setBaseShapesFilled(false);
            renderer.setDrawSeriesLineAsPath(true);
        }

        timeAxis = (DateAxis) plot.getDomainAxis();
        timeAxis.setDateFormatOverride(new SimpleDateFormat("HH:mm"));


        return chart;

    }    
    
    /**
     * Creates a panel for the Graph
     *
     * @return A panel.
     */
    public  JPanel createGraphPanel(JFreeChart chart) 
    {

        ChartPanel panel = new ChartPanel(chart);
        panel.setFillZoomRectangle(true);
        panel.setMouseWheelEnabled(false);
        panel.setPopupMenu(null);
        return panel;
    }    

    
    /**
     * This method creates a dataset for the graph. It plots the heart rate 
     * values (if they are sensible values).
     * @return The dataset.
     */
    private XYDataset createHeartrateDataset(List<HeartRatePoint> heartRateLog) 
    {
        TimeSeriesCollection    dataset;
        TimeSeries              chartData;
        ListIterator            iterator;
        HeartRatePoint          point;
        DateTime                dateTime;
        double                  heartRateValue;
        Second                  graphTimeStamp;
        
        chartData = new TimeSeries("Heartrate");
        iterator=heartRateLog.listIterator();
        
        while (iterator.hasNext())
        {
            point=(HeartRatePoint)iterator.next();
            
            // TO DO: CONVERT TO LOCAL TIME
            dateTime=point.getDateTime();
            heartRateValue=point.getHeartRateValue();
            
            if (heartRateValue>0)
            {
                graphTimeStamp=new Second(dateTime.getSecond(), 
                                          dateTime.getMinute(), 
                                          dateTime.getHour(),
                                          dateTime.getDay(), 
                                          dateTime.getMonth(), 
                                          dateTime.getYear());
                chartData.addOrUpdate(graphTimeStamp, point.getHeartRateValue());            
            }            
        }        

        dataset = new TimeSeriesCollection();
        dataset.addSeries(chartData);

        return dataset;

    }    
    
    
    public String showTrackHeartRateLog(String trackName, List<HeartRatePoint> heartRateLog)
    {
        String                  resultString;
        JPanel                  graphPanel;
        JFreeChart              chart;
        XYPlot                  plot;
                
      
        chart = createChart(createHeartrateDataset(heartRateLog));  
        chart.setTitle("Heartrate for "+trackName);
        plot=chart.getXYPlot();
        plot.getRangeAxis().setRange(0, 220);
//        plot.getDomainAxis().setLabel("hoi");
        graphPanel          =createGraphPanel(chart);

        
        this.add(graphPanel);
        
//        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLocationRelativeTo(null);
        this.setVisible(true);       
        
        resultString="";
        
        return resultString;
    }

    
   
    /**
     * This method creates a dataset for the graph. It adds the speed 
     * values (if they are sensible values).
     * @param tackLog The series of track log points containing the speed value
     * @return The dataset.
     */
    private XYDataset createSpeedDataset(TrackSegment trackSegment) 
    {
        TimeSeriesCollection    dataset;
        TimeSeries              chartData;
        ListIterator            iterator;
        TrackLogPoint           point;
        DateTime                dateTime;
        double                  speedValue;
        Second                  graphTimeStamp;


        
        dataset = new TimeSeriesCollection();
        

  
            chartData = new TimeSeries("Speed");


            iterator=trackSegment.getTrackPoints().listIterator();

            while (iterator.hasNext())
            {
                point=(TrackLogPoint)iterator.next();

                // TO DO: CONVERT TO LOCAL TIME
                dateTime=point.getDateTime();
                speedValue=point.getSpeed();

                if (speedValue>=0)
                {
                    graphTimeStamp=new Second(dateTime.getSecond(), 
                                              dateTime.getMinute(), 
                                              dateTime.getHour(),
                                              dateTime.getDay(), 
                                              dateTime.getMonth(), 
                                              dateTime.getYear());
                    chartData.addOrUpdate(graphTimeStamp, speedValue);            
                }            
            }        

            dataset.addSeries(chartData);

        return dataset;

    }      
    
    
    
    /**
     * This method draws a graph showing the speed of all segments in the 
     * indicated track
     * @param trackName Name/indication of the track
     * @param track The track to plot the speed from
     * @return String showing the result of the action 
     */
    public String showTrackSpeed(String trackName, Track track)
    {
        String                  resultString;
        JPanel                  graphPanel;
        JFreeChart              chart;
        XYPlot                  plot;
        int                     numberOfSegments;
        int                     segment;        
      
        // Create an empty chart
        chart = createChart(null);  
        chart.setTitle("Speed for "+trackName);
        plot=chart.getXYPlot();
        plot.getDomainAxis().setLabel("Time");
        plot.getRangeAxis().setLabel("Speed (m/s)");
        chart.getXYPlot().getRangeAxis().setAutoRange(true);


        numberOfSegments=track.getNumberOfSegments();
        segment=0;
        while (segment<numberOfSegments)
        {  
            chart.getXYPlot().setDataset(segment, createSpeedDataset(track.getSegment(segment)));
            chart.getXYPlot().setRenderer(segment, new StandardXYItemRenderer());
            segment++;
        }
 
        graphPanel          =createGraphPanel(chart);
        
        this.add(graphPanel);
        
//        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLocationRelativeTo(null);
        this.setVisible(true);       
        
        resultString="";
        
        return resultString;
    }    
    
    
}
