/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import java.io.File;

/**
 *
 * @author UserXP
 */
public class GpxReader implements IgotuReader
{
    private static GpxReader theInstance=null;

    /**
     * Private constructor
     */
    private GpxReader()
    {

    }

    /**
     * This method returns the one and only instance of this singleton class
     * @return The instance
     */
    public static GpxReader getInstance()
    {
        if (theInstance==null)
        {
            theInstance=new GpxReader();
        }
        return theInstance;
    }

    /**
     * This method returns an element
     * @param parent Parent from which the element is obtained
     * @param elementName Name of the element
     * @return The element or null if not found
     */
    private Element getChildElement(Element parent, String elementName)
    {
        Element     element;
        NodeList    nodeList;

        element=null;
        nodeList=parent.getElementsByTagName(elementName);

        if (nodeList.getLength()==1)
        {
            if (nodeList.item(0).getNodeType()==Node.ELEMENT_NODE)
            {
                element=(Element)nodeList.item(0);
            }
        }
        else
        {
            DebugLogger.error("Number of nodes <"+ elementName+
                              "> tags in GPX file not equal to one as expected...");
        }

        return element;
    }

    /**
     * This method returns the value of a child element
     * @param parent The parent element
     * @param tagName The name of the child element
     * @return The value of the child element
     */
    private String getChildElementValue(Element parent, String tagName)
    {
        Element  element;
        String   value;
        NodeList list;
        Node     node;

        element=this.getChildElement(parent, tagName);

        if (element!=null)
        {
            list=element.getChildNodes();
            node=list.item(0);
            if (node!=null)
            {
                value=node.getNodeValue();
            }
            else
            {
                value="";
            }
        }
        else
        {
            value="";
            DebugLogger.error("Tag <"+tagName+"> not found in GPX file");
        }
        return value;
    }

    /**
     * This method reads a route consisting of waypoints from file
     * @param fileName Name of the file to read from
     */
    public void readRouteFromFile(String fileName)

    {
        File                    fXmlFile;
        DocumentBuilderFactory  dbFactory;
        DocumentBuilder         dBuilder;
        Document                doc;
        Element                 gpxElement;
        Element                 routeElement;
        NodeList                nList;
        Node                    nNode;
        Element                 eElement;
        int                     i;
        RouteLog                routeLog;
        RoutePoint              waypoint;

        double                  longitude;
        double                  latitude;
        double                  elevation;
        String                  name;
        String                  symbol;
        String                  value;

        routeLog=RouteLog.getInstance();

        routeLog.clear();
        try
        {

            fXmlFile = new File(fileName);
            dbFactory = DocumentBuilderFactory.newInstance();
            dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();


            gpxElement=doc.getDocumentElement();
            if (gpxElement.getNodeName().equals("gpx"))
            {
                // First try to to load points from a <rte>
                routeElement=this.getChildElement(gpxElement, "rte");

                if (routeElement!=null)
                {
                    // If succeeded, get the points from the route
                    nList = routeElement.getElementsByTagName("rtept");
                }
                else
                {
                    // If not, try if the GPX file contains waypoints
                    nList = gpxElement.getElementsByTagName("wpt");
                }

                if ((nList!=null) && (nList.getLength()>0))
                {
                    i=0;
                    while (i<nList.getLength())
                    {
                       nNode = nList.item(i);
                       if (nNode.getNodeType() == Node.ELEMENT_NODE)
                       {
                          eElement = (Element) nNode;

                          longitude =Double.parseDouble(eElement.getAttribute("lon"));
                          latitude  =Double.parseDouble(eElement.getAttribute("lat"));
                          name      =getChildElementValue(eElement, "name");
                          symbol    =getChildElementValue(eElement, "sym");

                          value =getChildElementValue(eElement, "ele");
                          if (!value.equals(""))
                          {
                              elevation=Double.parseDouble(value);
                          }
                          else
                          {
                              elevation=0.0;
                          }

                          elevation=0.0;

                          waypoint=new RoutePoint((int)(longitude*1e7), (int)(latitude*1e7), 
                                                  (int)(elevation*100.0), name, symbol);
                          routeLog.appendWaypoint(waypoint);
                       }
                       i++;
                    }
                }
                else
                {
                    DebugLogger.error("No <rte> or <wpt> data in GPX file");
                }

                routeLog.dumpLog();
            }
            else
            {
                DebugLogger.error(fileName+" does not seem to be a GPX file");
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

    }



}
