/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;

/**
 * This class represents a log entry as stored in the device track memory.
 * In the device it is stored as an entry with flags (1st byte) 0xf1
 * @author Jorgen
 */
public class DeviceLogEntry
{
    private DateTime    dateTime;
    private String      message;
    
    /**
     * The constructor
     * @param dateTime Original timestamp in UTC
     * @param message The log message
     */
    public DeviceLogEntry(DateTime dateTime, String message)
    {
        this.dateTime=dateTime;
        this.message=message;
    }

    /**
     * This method return the original timestamp of the message as
     * stored in the device. It is in UTC
     * @return The timestamp
     */
    DateTime getDateTime()
    {
        return dateTime;
    }

    /**
     * This method returns the time stamp of the log message in local time.
     * @return The timestamp of the message in local time
     */
    DateTime getLocalDateTime()
    {
        return ToolBox.convertUtcToLocal(dateTime);
    }

    /**
     * This method returns the log message
     * @return The message
     */
    String getLogMessage()
    {
        return message;
    }

    /**
     * This method returns a string describing the DeviceLogEntry.
     * @return Descriptive string
     */
    @Override
    public String toString()
    {
        return new String(dateTime.format("YYYY-MM-DD hh:mm:ss")+"(UTC) "+message);
    }



}
