/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

import java.util.ArrayList;
import java.util.Iterator;

import hirondelle.date4j.DateTime;
import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.IOException;

/**
 * Repository of log messages from the Device
 * @author UserXP
 */
public class DeviceLog
{
    /** The one and only instance of this Singleton class     */
    private static DeviceLog        theInstance=null;

    private ArrayList<DeviceLogEntry>  theLog;

    /**
     * Private constructor
     */
    private DeviceLog()
    {
        theLog=new ArrayList<DeviceLogEntry>();
    }

    /**
     * This method returns the one and only instance of this Singleton class.
     * If it does not exist, it creates it on the fly...
     * @return The instance
     */
    public static DeviceLog getInstance()
    {
        if (theInstance==null)
        {
            theInstance=new DeviceLog();
        }

        return theInstance;
    }

    /**
     * This method converts track log data to DeviceLogEntries.
     * @param data Device data
     * @param length Length of the data in bytes. Must be multiple of 0x20
     */
    public void appendData(byte[] data, int length)
    {
        int             i;
        int             j;
        DateTime        dateTime;
        byte[]          logString;
        int             number;
        DeviceLogEntry  entry;
        byte            nextByte;

        if (length%0x20==0)
        {

            number=length/0x20;

            logString=new byte[24];
            i=0;
            while (i<number)
            {
                if ((data[i*0x20+0]&0xff)==0xf1)
                {
                    dateTime=ToolBox.bytesToDateTime(data[i*0x20+1],
                                                     data[i*0x20+2],
                                                     data[i*0x20+3],
                                                     data[i*0x20+4],
                                                     data[i*0x20+5]);
                    j=0;
                    while (j<24)
                    {
                        nextByte=data[i*0x20+6+j];
                        if (nextByte!=0)
                        {
                            logString[j]=nextByte;
                        }
                        else
                        {
                            logString[j]=' ';
                        }
                        j++;
                    }
                    

                    entry=new DeviceLogEntry(dateTime, new String(logString));
                    theLog.add(entry);

                    DebugLogger.debug("Device Log entry: "+entry.toString());

                }
                i++;
            }
        }
        else
        {
            DebugLogger.error("Invalid block size when converting data to DeviceLog");
        }
    }

    /**
     * This method clears the log and discards all entries.
     */
    public void clear()
    {
        theLog.clear();
    }

    /**
     * This method returns the vector with DeviceLogEntries
     * @return The Vector containing the log entries.
     */
    public ArrayList<DeviceLogEntry> getDeviceLogEntries()
    {
        return theLog;
    }

    /**
     * This method returns the number of log entries in the log.
     * @return The number of entries
     */
    public int getNumberOfEntries()
    {
        return theLog.size();
    }

    /**
     * This method writes the Device log to a text file.
     * @param fileName Full name incl. path of the text file
     */
    public void writeToFile(String fileName)
    {
        FileWriter                  outFile;
        PrintWriter                 out;
        int                         count;
        DeviceLogEntry              entry;
        Iterator<DeviceLogEntry>    iterator;
        String                      outputString;

        try
        {
          outFile = new FileWriter(fileName);
          out = new PrintWriter(outFile);

          // Also could be written as follows on one line
          // Printwriter out = new PrintWriter(new FileWriter(args[0]));

          // Write text to file
          iterator=theLog.iterator();
          count=0;
          while (iterator.hasNext())
          {
              entry=iterator.next();
              out.println(String.format("%4d", count)+": "+entry.toString());
              count++;
          }

          out.close();
        }
        catch (IOException e)
        {
            DebugLogger.error("Error writing file "+fileName);
        }
    }

}
