/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.TimeZone;

/**
 *
 * @author jorgen
 */
public class DebugLogger 
{
    public static final int     DEBUGLEVEL_DEBUG=0;
    public static final int     DEBUGLEVEL_INFO =1;
    public static final int     DEBUGLEVEL_ERROR=2;
    public static final int     DEBUGLEVEL_OFF  =3;

    private static int          debugLevel=DEBUGLEVEL_ERROR;
    
    /**
     *  Private constructor: this class cannot be instantiated
     */
    private DebugLogger()
    {
        
    } 
           
    /**
     * Set debugging on or off
     * @param on True turns on the debuggin, false turns it off
     */
    public static void setDebugLevel(int newDebugLevel)
    {
        if ((newDebugLevel>=DEBUGLEVEL_DEBUG) && (newDebugLevel<=DEBUGLEVEL_OFF))
        {
            debugLevel=newDebugLevel;
        }
    }
    
    public static int getDebugLevel()
    {
        return debugLevel;
    }
    
    /**
     * Write info. Info is written to System.out when debugging is on.
     * @param info The info
     */
    public static void debug(String info)
    {
        DateTime time;
        if (debugLevel<=DEBUGLEVEL_DEBUG)
        {
            time=DateTime.now(TimeZone.getDefault());
            System.out.println("d " + time.format("YYYY-MM-DD hh:mm:ss  ")+info);
        }
    }

    
    /**
     * Write info. Info is written to System.out when debugging is on.
     * @param info The info
     */
    public static void info(String info)
    {
        DateTime time;
        if (debugLevel<=DEBUGLEVEL_INFO)
        {
            time=DateTime.now(TimeZone.getDefault());
            System.out.println("i "+time.format("YYYY-MM-DD hh:mm:ss  ")+info);
        }
    }

    /**
     * Write error message. Error messages are written to System.err if debugging
     * is on
     * @param info The message 
     */
    public static void error(String info)
    {
        DateTime time;
        if (debugLevel<=DEBUGLEVEL_ERROR)
        {
            time=DateTime.now(TimeZone.getDefault());
            System.err.println("e "+time.format("YYYY-MM-DD hh:mm:ss  ERROR: ")+info);
        }
    }
    
    
    /**
     * This method returns the debug level defined by the parameter as a string
     * @param debugLevel The debug level to convert
     * @return The string represenging the debug level or 'unknown' if 
     *         it could not be translated
     */
    public static String debugLevelToString(int debugLevel)
    {
        String returnString;
        
        returnString="unknown";
        
        if (debugLevel==DEBUGLEVEL_OFF)
        {
            returnString="off";
        }
        else if (debugLevel==DEBUGLEVEL_DEBUG)
        {
            returnString="debug";
        }
        else if (debugLevel==DEBUGLEVEL_INFO)
        {
            returnString="info";
        }
        else if (debugLevel==DEBUGLEVEL_ERROR)
        {
            returnString="error";
        }
        
        return returnString;
    }
    
    /**
     * This method returns current debug level as a string
     * @param debugLevel The debug level to convert
     * @return The string represenging the debug level or 'unknown' if 
     *         it could not be translated
     */
    public static String debugLevelToString()
    {
        String returnString;
        
        returnString="unknown";
        
        if (debugLevel==DEBUGLEVEL_OFF)
        {
            returnString="off";
        }
        else if (debugLevel==DEBUGLEVEL_DEBUG)
        {
            returnString="debug";
        }
        else if (debugLevel==DEBUGLEVEL_INFO)
        {
            returnString="info";
        }
        else if (debugLevel==DEBUGLEVEL_ERROR)
        {
            returnString="error";
        }
        
        return returnString;
    }    
}
