/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

//Sun's serial port driver
import gnu.io.*;
//import javax.comm.*;
import java.io.*;
import java.util.TooManyListenersException;
import java.util.Enumeration;
import java.util.ArrayList;

/**
 * This class implements the connection to an i-gotU device via a comport.
 * It inherits from the Connection class, implementing the actual protocol at
 * application level.
 * @author Jorgen
 */
public class ConnectionSerialRxtx extends ConnectionSerial implements SerialPortEventListener
{
    static private CommPortIdentifier   portId1;
    private InputStream                 inputStream;
    private OutputStream                outputStream;
    private SerialPort                  serialPort1;
    
    public ConnectionSerialRxtx()
    {
        super();
    }
    
    
    /**
    *  This method returns a list of comport names.
    * @return Array list of strings containing the comport names
    */
    @Override
    public ArrayList<String> getComportList()
    {
        Enumeration         portIdentifiers;
        CommPortIdentifier  pid;
        ArrayList<String>   ports;
        
        // Else, scan the comports
        portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        
        // Create the array list and add the identifier names
        ports=new ArrayList<String>();
        while (portIdentifiers.hasMoreElements())
        {
             pid = (CommPortIdentifier) portIdentifiers.nextElement();
             ports.add(pid.getName());
        }        
        return ports;
    }
    
   /**
     * Opens connection to the device
     * @param comportNumber Number of the comport to which the igotu is attached
     * @author Jorgen van der Velde
     */
    @Override
    public void open(String comport)
    {
        // Get port info
        try
        {
          portId1 = CommPortIdentifier.getPortIdentifier(comport);
        }

        catch (Exception e)
        {
            DebugLogger.error("Error while getting comport ID for comport "+comport);
        }

        // Open port
        try
        {
            serialPort1 = (SerialPort) portId1.open("igotu2gpx2", 2000);
            DebugLogger.info("Comport " + portId1.getName() + " opened");

        }
        catch (PortInUseException e)
        {
            DebugLogger.error("Error opening comport "+comport+": port in use");
        }


        try
        {
            inputStream = serialPort1.getInputStream();
            outputStream = serialPort1.getOutputStream();
        }
        catch (IOException e)
        {
            DebugLogger.error("IO Exception while getting comport streams");
        }

        try
        {
            serialPort1.addEventListener(this);
            DebugLogger.debug("Eventlistener added");
        }
        catch (TooManyListenersException e)
        {
            DebugLogger.error("Error adding eventlistener - to many listeners");
        }


        serialPort1.notifyOnDataAvailable(true);

        // Set port params
        /*
        try
        {

            serialPort1.setSerialPortParams(9600,
                SerialPort.DATABITS_8,
                SerialPort.STOPBITS_1,
                SerialPort.PARITY_NONE);

         //   serialPort1.setDTR(false);
         //   serialPort1.setRTS(false);


        }
        catch (UnsupportedCommOperationException e)
        {
            DebugLogger.error("Error configuring port");
        }
        */
    }
    
    /**
     * This method closes the comport 
     */
    @Override
    public void close()
    {
        if (serialPort1!=null)
        {
            serialPort1.removeEventListener();
            serialPort1.close();
        }
        DebugLogger.info("Comport closed");
    }
    
    
    /**
     * This method reads the bytes from the comport and writes them in the buffer
     * @param buffer Buffer to write bytes to
     * @return The number of bytes read
     */
    @Override
    int comportRead(byte[] buffer)
    {
        int bytesRead;
        
        bytesRead=0;
        
        // Read the bytes into the buffer
        try
        {
            bytesRead=inputStream.read(buffer);
        }
        catch (IOException e)
        {
            DebugLogger.error("Error receiving bytes");
        }        
        return bytesRead;
    }
    
    /**
     * This method writes bytes to the comport
     * @param buffer Bytes to write
     * @param length Number of bytes to write
     * @return False if succeeded, true if not
     */
    @Override
    boolean comportWrite(byte[] buffer, int length)
    {
        try
        {
            outputStream.write(buffer, 0, length);
        }
        catch (IOException e)
        {
            DebugLogger.error("IO Exception writing to comport");
        }        
        return false;
    }
    
    
    /**
     * Eventlistener
     * @param event The event
     * @author Jorgen van der Velde
     */
    
    public void serialEvent(SerialPortEvent event)
    {

        switch(event.getEventType())
        {
        case SerialPortEvent.BI:
        case SerialPortEvent.OE:
        case SerialPortEvent.FE:
        case SerialPortEvent.PE:
        case SerialPortEvent.CD:
        case SerialPortEvent.CTS:
        case SerialPortEvent.DSR:
        case SerialPortEvent.RI:
        case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
            break;
        case SerialPortEvent.DATA_AVAILABLE:
            this.handeRxEvent();
            break;
        }
    }


    
}
