/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.deepocean.u_gotme;

// Java Simple Serial Com
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortList;
//import javax.comm.*;
import java.io.*;
import java.util.TooManyListenersException;
import java.util.Enumeration;
import java.util.ArrayList;

/**
 * This class implements the connection to an i-gotU device via a comport.
 * It inherits from the Connection class, implementing the actual protocol at
 * application level.
 * @author Jorgen
 */
public class ConnectionSerialJssc extends ConnectionSerial implements SerialPortEventListener
{
    private SerialPort                  serialPort1;
    
    public ConnectionSerialJssc()
    {
        super();
    }
    
    
    /**
    *  This method returns a list of comport names.
    * @return Array list of strings containing the comport names
    */
    @Override
    public ArrayList<String> getComportList()
    {
        ArrayList<String>   ports;
        String[]            portList;
        int                 i;
        
        portList=SerialPortList.getPortNames();
        ports   =new ArrayList<String>();
        i=0;
        while (i<portList.length)
        {
            ports.add(portList[i]);
            i++;
        }
        return ports;
    }
    
   /**
     * Opens connection to the device
     * @param comportNumber Number of the comport to which the igotu is attached
     * @author Jorgen van der Velde
     */
    @Override
    public void open(String comport)
    {
        int mask;


        // Open port
        serialPort1 = new SerialPort(comport);

        try
        {
            serialPort1.openPort();
        }
        catch (SerialPortException e)
        {
            DebugLogger.error("Error opening comport "+comport+": "+e.getMessage());
        }

        // Set port params
        try
        {

            serialPort1.setParams(SerialPort.BAUDRATE_9600,
                SerialPort.DATABITS_8,
                SerialPort.STOPBITS_1,
                SerialPort.PARITY_NONE);

        }
        catch (SerialPortException e)
        {
            DebugLogger.error("Error configuring port "+e.getMessage());
        }

       
        try
        {
            mask = SerialPort.MASK_RXCHAR;//Prepare mask
            serialPort1.setEventsMask(mask);//Set mask
            serialPort1.addEventListener(this);
            DebugLogger.debug("Eventlistener added");
        }
        catch (SerialPortException e)
        {
            DebugLogger.error("Error adding eventlistener - "+e.getMessage());
        }


    }
    
    /**
     * This method closes the comport 
     */
    @Override
    public void close()
    {
        if (serialPort1!=null)
        {
            try
            {
                serialPort1.removeEventListener();


                serialPort1.closePort();
                serialPort1=null;
            }
            catch (SerialPortException e)
            {
                DebugLogger.error("Error closing comport: "+e.getMessage());
            }
        }
        DebugLogger.info("Comport closed");
    }
        
    
    /**
     * This method reads the bytes from the comport and writes them in the buffer
     * @param buffer Buffer to write bytes to
     * @return The number of bytes read
     */
    @Override
    int comportRead(byte[] buffer)
    {
        int     bytesRead;
        byte[]  comportBuffer;
        int     i;
        
        bytesRead=0;
        
        // Read the bytes into the buffer
        try 
        {
            bytesRead=0;
            if (serialPort1!=null && serialPort1.getInputBufferBytesCount()>0)
            {
               comportBuffer=serialPort1.readBytes();
               bytesRead=comportBuffer.length;
               i=0;
               while (i<bytesRead)
               {
                   buffer[i]=comportBuffer[i];
                   i++;
               }
            }
        }
        catch (SerialPortException e) 
        {
            DebugLogger.error("Error reading comport "+e.getMessage());
        }  
        return bytesRead;
    }
    
    /**
     * This method writes bytes to the comport
     * @param buffer Bytes to write NOTE: LENGTH OF BUFFER DEFINES BYTES TO SEND
     * @param length Number of bytes to write NOTE: NOT USED
     * @return False if succeeded, true if not
     */
    @Override
    boolean comportWrite(byte[] buffer, int length)
    {
        try
        {
            serialPort1.writeBytes(buffer);
        }
        catch (SerialPortException e)
        {
            DebugLogger.error("IO Exception writing to comport: "+e.getMessage());
        }     
        return false;
    }
    
    
    /**
     * Eventlistener
     * @param event The event
     * @author Jorgen van der Velde
     */
    
    @Override    
    public void serialEvent(SerialPortEvent event) 
    {
        if(event.isRXCHAR())
        {
            this.handeRxEvent();
        }
    }

    
}
