/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package net.deepocean.u_gotme;

/**
 * This class represents a command to be executed by the CommunicationProcess.
 * @author UserXP
 */
public class Command
{
    /** Enum with possible commands */
    public enum CommandType
    {
        COMMAND_DOWNLOADTRACKS,
        COMMAND_ERASETRACKS,
        COMMAND_GETINFO,
        COMMAND_UPLOADROUTE,
        COMMAND_DOWNLOADWAYPOINTS,
        COMMAND_GETDEVICETYPE,
        COMMAND_DOWNLOADROUTE,
        COMMAND_SAVESIMULATIONSET,        
        COMMAND_SAVEDEVICESETTINGS,        
        COMMAND_RESTOREDEVICESETTINGS,
        COMMAND_SAVEDEVICESETTINGSASTEXT,
        COMMAND_ERASEROUTE,
        COMMAND_VERIFYCACHEFILE
    }
    
    /** The command */
    public CommandType                      command;
    
    /** The comport to use for communication */
    public String                           comport;

    /**
     * Constructor, creates the Command 
     * @param command The command to execute
     * @param comport The comport to use
     */
    public Command(CommandType command, String comport)
    {
        this.command=command;
        this.comport=comport;
    }

    /**
     * Copy constructor.
     * @param command Command instance to copy
     */
    public Command(Command command)
    {
        this.command=command.command;
        this.comport=command.comport;
    }

}
