/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;
import java.util.Locale;
import java.util.TimeZone;

public final class Examples {
    public static void main(String ... stringArray) {
        Examples examples = new Examples();
        examples.currentDateTime();
        examples.currentDateTimeInCairo();
        examples.ageIfBornOnCertainDate();
        examples.optionsExpiry();
        examples.daysTillChristmas();
        examples.whenIs90DaysFromToday();
        examples.whenIs3Months5DaysFromToday();
        examples.hoursDifferenceBetweenParisAndPerth();
        examples.weeksSinceStart();
        examples.timeTillMidnight();
        examples.imitateISOFormat();
        examples.jdkDatesSuctorial();
    }

    private static void log(Object object) {
        System.out.println(String.valueOf(object));
    }

    private void currentDateTime() {
        DateTime dateTime = DateTime.now(TimeZone.getDefault());
        String string = dateTime.format("YYYY-MM-DD hh:mm:ss");
        Examples.log("Current date-time in default time zone : " + string);
    }

    private void currentDateTimeInCairo() {
        DateTime dateTime = DateTime.now(TimeZone.getTimeZone("Africa/Cairo"));
        String string = dateTime.format("YYYY-MM-DD hh:mm:ss (WWWW)", Locale.getDefault());
        Examples.log("Current date-time in Cairo : " + string);
    }

    private void ageIfBornOnCertainDate() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        DateTime dateTime2 = DateTime.forDateOnly(1995, 5, 16);
        int n = dateTime.getYear() - dateTime2.getYear();
        if (dateTime.getDayOfYear() < dateTime2.getDayOfYear()) {
            --n;
        }
        Examples.log("Age of someone born May 16, 1995 is : " + n);
    }

    private void optionsExpiry() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        DateTime dateTime2 = dateTime.getStartOfMonth();
        int n = 0;
        n = dateTime2.getWeekDay() == 7 ? 21 : 21 - dateTime2.getWeekDay();
        DateTime dateTime3 = DateTime.forDateOnly(dateTime2.getYear(), dateTime2.getMonth(), n);
        Examples.log("The 3rd Friday of this month is : " + dateTime3.format("YYYY-MM-DD"));
    }

    private void daysTillChristmas() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        DateTime dateTime2 = DateTime.forDateOnly(dateTime.getYear(), 12, 25);
        int n = 0;
        if (!dateTime.isSameDayAs(dateTime2)) {
            if (dateTime.lt(dateTime2)) {
                n = dateTime.numDaysFrom(dateTime2);
            } else if (dateTime.gt(dateTime2)) {
                DateTime dateTime3 = DateTime.forDateOnly(dateTime.getYear() + 1, 12, 25);
                n = dateTime.numDaysFrom(dateTime3);
            }
        }
        Examples.log("Number of days till Christmas : " + n);
    }

    private void whenIs90DaysFromToday() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        Examples.log("90 days from today is : " + dateTime.plusDays(60).format("YYYY-MM-DD"));
    }

    private void whenIs3Months5DaysFromToday() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        DateTime dateTime2 = dateTime.plus(0, 3, 5, 0, 0, 0, DateTime.DayOverflow.FirstDay);
        Examples.log("3 months and 5 days from today is : " + dateTime2.format("YYYY-MM-DD"));
    }

    private void hoursDifferenceBetweenParisAndPerth() {
        DateTime dateTime = DateTime.now(TimeZone.getTimeZone("Europe/Paris"));
        DateTime dateTime2 = DateTime.now(TimeZone.getTimeZone("Australia/Perth"));
        int n = dateTime2.getHour() - dateTime.getHour();
        if (n < 0) {
            n += 24;
        }
        Examples.log("Numbers of hours difference between Paris and Perth : " + n);
    }

    private void weeksSinceStart() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        DateTime dateTime2 = DateTime.forDateOnly(2010, 9, 6);
        int n = dateTime.getWeekIndex() - dateTime2.getWeekIndex();
        Examples.log("The number of weeks since Sep 6, 2010 : " + n);
    }

    private void timeTillMidnight() {
        DateTime dateTime = DateTime.now(TimeZone.getDefault());
        DateTime dateTime2 = dateTime.plusDays(1).getStartOfDay();
        long l = dateTime.numSecondsFrom(dateTime2);
        Examples.log("This many seconds till midnight : " + l);
    }

    private void imitateISOFormat() {
        DateTime dateTime = DateTime.now(TimeZone.getDefault());
        Examples.log("Output using the 'T' found in ISO formats: " + dateTime.format("YYYY-MM-DDThh:mm:ss"));
    }

    private void jdkDatesSuctorial() {
        DateTime dateTime = DateTime.today(TimeZone.getDefault());
        DateTime dateTime2 = DateTime.forDateOnly(1996, 1, 23);
        int n = dateTime.getYear() - dateTime2.getYear();
        Examples.log("The number of years the JDK date-time API has been suctorial : " + n);
    }
}

