/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;
import hirondelle.date4j.Util;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DateTimeFormatter {
    private final String fFormat;
    private final Locale fLocale;
    private Collection<InterpretedRange> fInterpretedRanges;
    private Collection<EscapedRange> fEscapedRanges;
    private final Map<Locale, List<String>> fMonths = new LinkedHashMap<Locale, List<String>>();
    private final Map<Locale, List<String>> fWeekdays = new LinkedHashMap<Locale, List<String>>();
    private final Map<Locale, List<String>> fAmPm = new LinkedHashMap<Locale, List<String>>();
    private final CustomLocalization fCustomLocalization;
    private static final String ESCAPE_CHAR = "|";
    private static final Pattern ESCAPED_RANGE = Pattern.compile("\\|[^\\|]*\\|");
    private static final String YYYY = "YYYY";
    private static final String YY = "YY";
    private static final String M = "M";
    private static final String MM = "MM";
    private static final String MMM = "MMM";
    private static final String MMMM = "MMMM";
    private static final String D = "D";
    private static final String DD = "DD";
    private static final String WWW = "WWW";
    private static final String WWWW = "WWWW";
    private static final String hh = "hh";
    private static final String h = "h";
    private static final String m = "m";
    private static final String mm = "mm";
    private static final String s = "s";
    private static final String ss = "ss";
    private static final String h12 = "h12";
    private static final String hh12 = "hh12";
    private static final int AM = 0;
    private static final int PM = 1;
    private static final String a = "a";
    private static final Pattern FRACTIONALS = Pattern.compile("f{1,9}");
    private static final String EMPTY_STRING = "";
    private static final List<String> TOKENS = new ArrayList<String>();

    DateTimeFormatter(String string) {
        this.fFormat = string;
        this.fLocale = null;
        this.fCustomLocalization = null;
        this.validateState();
    }

    DateTimeFormatter(String string, Locale locale) {
        this.fFormat = string;
        this.fLocale = locale;
        this.fCustomLocalization = null;
        this.validateState();
    }

    DateTimeFormatter(String string, List<String> list, List<String> list2, List<String> list3) {
        this.fFormat = string;
        this.fLocale = null;
        this.fCustomLocalization = new CustomLocalization(list, list2, list3);
        this.validateState();
    }

    String format(DateTime dateTime) {
        this.fEscapedRanges = new ArrayList<EscapedRange>();
        this.fInterpretedRanges = new ArrayList<InterpretedRange>();
        this.findEscapedRanges();
        this.interpretInput(dateTime);
        return this.produceFinalOutput();
    }

    private void findEscapedRanges() {
        Matcher matcher = ESCAPED_RANGE.matcher(this.fFormat);
        while (matcher.find()) {
            EscapedRange escapedRange = new EscapedRange();
            escapedRange.Start = matcher.start();
            escapedRange.End = matcher.end() - 1;
            this.fEscapedRanges.add(escapedRange);
        }
    }

    private boolean isInEscapedRange(InterpretedRange interpretedRange) {
        boolean bl = false;
        for (EscapedRange escapedRange : this.fEscapedRanges) {
            if (escapedRange.Start > interpretedRange.Start || interpretedRange.Start > escapedRange.End) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void interpretInput(DateTime dateTime) {
        String string = this.fFormat;
        for (String string2 : TOKENS) {
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                InterpretedRange interpretedRange = new InterpretedRange();
                interpretedRange.Start = matcher.start();
                interpretedRange.End = matcher.end() - 1;
                if (this.isInEscapedRange(interpretedRange)) continue;
                interpretedRange.Text = this.interpretThe(matcher.group(), dateTime);
                this.fInterpretedRanges.add(interpretedRange);
            }
            string = string.replace(string2, this.withCharDenotingAlreadyInterpreted(string2));
        }
    }

    private String withCharDenotingAlreadyInterpreted(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= string.length(); ++i) {
            stringBuilder.append("@");
        }
        return stringBuilder.toString();
    }

    private String produceFinalOutput() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.fFormat.length(); ++i) {
            String string = this.nextLetter(i);
            InterpretedRange interpretedRange = this.getInterpretation(i);
            if (interpretedRange != null) {
                stringBuilder.append(interpretedRange.Text);
                i = interpretedRange.End;
                continue;
            }
            if (ESCAPE_CHAR.equals(string)) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private InterpretedRange getInterpretation(int n) {
        InterpretedRange interpretedRange = null;
        for (InterpretedRange interpretedRange2 : this.fInterpretedRanges) {
            if (interpretedRange2.Start != n) continue;
            interpretedRange = interpretedRange2;
        }
        return interpretedRange;
    }

    private String nextLetter(int n) {
        return this.fFormat.substring(n, n + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String interpretThe(String string, DateTime dateTime) {
        String string2 = EMPTY_STRING;
        if (YYYY.equals(string)) {
            return this.valueStr(dateTime.getYear());
        }
        if (YY.equals(string)) {
            return this.noCentury(this.valueStr(dateTime.getYear()));
        }
        if (MMMM.equals(string)) {
            int n = dateTime.getMonth();
            return this.fullMonth(n);
        }
        if (MMM.equals(string)) {
            int n = dateTime.getMonth();
            return this.firstThreeChars(this.fullMonth(n));
        }
        if (MM.equals(string)) {
            return this.addLeadingZero(this.valueStr(dateTime.getMonth()));
        }
        if (M.equals(string)) {
            return this.valueStr(dateTime.getMonth());
        }
        if (DD.equals(string)) {
            return this.addLeadingZero(this.valueStr(dateTime.getDay()));
        }
        if (D.equals(string)) {
            return this.valueStr(dateTime.getDay());
        }
        if (WWWW.equals(string)) {
            int n = dateTime.getWeekDay();
            return this.fullWeekday(n);
        }
        if (WWW.equals(string)) {
            int n = dateTime.getWeekDay();
            return this.firstThreeChars(this.fullWeekday(n));
        }
        if (hh.equals(string)) {
            return this.addLeadingZero(this.valueStr(dateTime.getHour()));
        }
        if (h.equals(string)) {
            return this.valueStr(dateTime.getHour());
        }
        if (h12.equals(string)) {
            return this.valueStr(this.twelveHourStyle(dateTime.getHour()));
        }
        if (hh12.equals(string)) {
            return this.addLeadingZero(this.valueStr(this.twelveHourStyle(dateTime.getHour())));
        }
        if (a.equals(string)) {
            int n = dateTime.getHour();
            return this.amPmIndicator(n);
        }
        if (mm.equals(string)) {
            return this.addLeadingZero(this.valueStr(dateTime.getMinute()));
        }
        if (m.equals(string)) {
            return this.valueStr(dateTime.getMinute());
        }
        if (ss.equals(string)) {
            return this.addLeadingZero(this.valueStr(dateTime.getSecond()));
        }
        if (s.equals(string)) {
            return this.valueStr(dateTime.getSecond());
        }
        if (!string.startsWith("f")) throw new IllegalArgumentException("Unknown token in date formatting pattern: " + string);
        Matcher matcher = FRACTIONALS.matcher(string);
        if (!matcher.matches()) throw new IllegalArgumentException("Unknown token in date formatting pattern: " + string);
        String string3 = this.nanosWithLeadingZeroes(dateTime.getNanoseconds());
        int n = string.length();
        return this.firstNChars(string3, n);
    }

    private String valueStr(Object object) {
        String string = EMPTY_STRING;
        if (object != null) {
            string = String.valueOf(object);
        }
        return string;
    }

    private String noCentury(String string) {
        String string2 = EMPTY_STRING;
        if (Util.textHasContent(string)) {
            string2 = string.substring(2);
        }
        return string2;
    }

    private String nanosWithLeadingZeroes(Integer n) {
        String string = this.valueStr(n);
        while (string.length() < 9) {
            string = "0" + string;
        }
        return string;
    }

    private String addLeadingZero(String string) {
        String string2 = string;
        if (Util.textHasContent(string) && string.length() == 1) {
            string2 = "0" + string2;
        }
        return string2;
    }

    private String firstThreeChars(String string) {
        String string2 = string;
        if (Util.textHasContent(string) && string.length() >= 3) {
            string2 = string.substring(0, 3);
        }
        return string2;
    }

    private String fullMonth(Integer n) {
        String string = EMPTY_STRING;
        if (n != null) {
            if (this.fCustomLocalization != null) {
                string = this.lookupCustomMonthFor(n);
            } else if (this.fLocale != null) {
                string = this.lookupMonthFor(n);
            } else {
                throw new IllegalArgumentException("Your date pattern requires either a Locale, or your own custom localizations for text:" + Util.quote(this.fFormat));
            }
        }
        return string;
    }

    private String lookupCustomMonthFor(Integer n) {
        return this.fCustomLocalization.Months.get(n - 1);
    }

    private String lookupMonthFor(Integer n) {
        String string = EMPTY_STRING;
        if (!this.fMonths.containsKey(this.fLocale)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MMMM, this.fLocale);
            for (int i = 0; i <= 11; ++i) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(1, 2000);
                gregorianCalendar.set(2, i);
                gregorianCalendar.set(5, 15);
                String string2 = simpleDateFormat.format(gregorianCalendar.getTime());
                arrayList.add(string2);
            }
            this.fMonths.put(this.fLocale, arrayList);
        }
        string = this.fMonths.get(this.fLocale).get(n - 1);
        return string;
    }

    private String fullWeekday(Integer n) {
        String string = EMPTY_STRING;
        if (n != null) {
            if (this.fCustomLocalization != null) {
                string = this.lookupCustomWeekdayFor(n);
            } else if (this.fLocale != null) {
                string = this.lookupWeekdayFor(n);
            } else {
                throw new IllegalArgumentException("Your date pattern requires either a Locale, or your own custom localizations for text:" + Util.quote(this.fFormat));
            }
        }
        return string;
    }

    private String lookupCustomWeekdayFor(Integer n) {
        return this.fCustomLocalization.Weekdays.get(n - 1);
    }

    private String lookupWeekdayFor(Integer n) {
        String string = EMPTY_STRING;
        if (!this.fWeekdays.containsKey(this.fLocale)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE", this.fLocale);
            for (int i = 8; i <= 14; ++i) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(1, 2009);
                gregorianCalendar.set(2, 1);
                gregorianCalendar.set(5, i);
                String string2 = simpleDateFormat.format(gregorianCalendar.getTime());
                arrayList.add(string2);
            }
            this.fWeekdays.put(this.fLocale, arrayList);
        }
        string = this.fWeekdays.get(this.fLocale).get(n - 1);
        return string;
    }

    private String firstNChars(String string, int n) {
        String string2 = string;
        if (Util.textHasContent(string) && string.length() >= n) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private Integer twelveHourStyle(Integer n) {
        Integer n2 = n;
        if (n != null) {
            if (n == 0) {
                n2 = 12;
            } else if (n > 12) {
                n2 = n - 12;
            }
        }
        return n2;
    }

    private String amPmIndicator(Integer n) {
        String string = EMPTY_STRING;
        if (n != null) {
            if (this.fCustomLocalization != null) {
                string = this.lookupCustomAmPmFor(n);
            } else if (this.fLocale != null) {
                string = this.lookupAmPmFor(n);
            } else {
                throw new IllegalArgumentException("Your date pattern requires either a Locale, or your own custom localizations for text:" + Util.quote(this.fFormat));
            }
        }
        return string;
    }

    private String lookupCustomAmPmFor(Integer n) {
        String string = EMPTY_STRING;
        string = n < 12 ? this.fCustomLocalization.AmPmIndicators.get(0) : this.fCustomLocalization.AmPmIndicators.get(1);
        return string;
    }

    private String lookupAmPmFor(Integer n) {
        String string = EMPTY_STRING;
        if (!this.fAmPm.containsKey(this.fLocale)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getAmPmTextFor(6));
            arrayList.add(this.getAmPmTextFor(18));
            this.fAmPm.put(this.fLocale, arrayList);
        }
        string = n < 12 ? this.fAmPm.get(this.fLocale).get(0) : this.fAmPm.get(this.fLocale).get(1);
        return string;
    }

    private String getAmPmTextFor(Integer n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(a, this.fLocale);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2000);
        gregorianCalendar.set(2, 6);
        gregorianCalendar.set(5, 15);
        gregorianCalendar.set(11, n);
        return simpleDateFormat.format(gregorianCalendar.getTime());
    }

    private void validateState() {
        if (!Util.textHasContent(this.fFormat)) {
            throw new IllegalArgumentException("DateTime format has no content.");
        }
    }

    static {
        TOKENS.add(YYYY);
        TOKENS.add(YY);
        TOKENS.add(MMMM);
        TOKENS.add(MMM);
        TOKENS.add(MM);
        TOKENS.add(M);
        TOKENS.add(DD);
        TOKENS.add(D);
        TOKENS.add(WWWW);
        TOKENS.add(WWW);
        TOKENS.add(hh12);
        TOKENS.add(h12);
        TOKENS.add(hh);
        TOKENS.add(h);
        TOKENS.add(mm);
        TOKENS.add(m);
        TOKENS.add(ss);
        TOKENS.add(s);
        TOKENS.add(a);
        TOKENS.add("fffffffff");
        TOKENS.add("ffffffff");
        TOKENS.add("fffffff");
        TOKENS.add("ffffff");
        TOKENS.add("fffff");
        TOKENS.add("ffff");
        TOKENS.add("fff");
        TOKENS.add("ff");
        TOKENS.add("f");
    }

    private static final class EscapedRange {
        int Start;
        int End;

        private EscapedRange() {
        }
    }

    private static final class InterpretedRange {
        int Start;
        int End;
        String Text;

        private InterpretedRange() {
        }

        public String toString() {
            return "Start:" + this.Start + " End:" + this.End + " '" + this.Text + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CustomLocalization {
        List<String> Months;
        List<String> Weekdays;
        List<String> AmPmIndicators;

        CustomLocalization(List<String> list, List<String> list2, List<String> list3) {
            if (list.size() != 12) {
                throw new IllegalArgumentException("Your List of custom months must have size 12, but its size is " + list.size());
            }
            if (list2.size() != 7) {
                throw new IllegalArgumentException("Your List of custom weekdays must have size 7, but its size is " + list2.size());
            }
            if (list3.size() != 2) {
                throw new IllegalArgumentException("Your List of custom a.m./p.m. indicators must have size 2, but its size is " + list3.size());
            }
            this.Months = list;
            this.Weekdays = list2;
            this.AmPmIndicators = list3;
        }
    }
}

