/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jtermios.JTermios;
import jtermios.Termios;
import purejavacomm.PureJavaSerialPort;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class RawStream {
    public static InputStream getInputStream(SerialPort port) throws IOException {
        if (!(port instanceof PureJavaSerialPort)) {
            return port.getInputStream();
        }
        if (Platform.isWindows()) {
            return port.getInputStream();
        }
        int FD = ((PureJavaSerialPort)port).getNativeFileDescriptor();
        if (NativeLong.SIZE == 4) {
            return new RawPosix32bInputStream(FD);
        }
        if (NativeLong.SIZE == 8) {
            return new RawPosix64bInputStream(FD);
        }
        return null;
    }

    public static void configureThresholdTimeout(SerialPort port, int threshold, int timeout) throws UnsupportedCommOperationException, IOException {
        Termios termios2;
        if (!(port instanceof PureJavaSerialPort) || Platform.isWindows()) {
            port.enableReceiveTimeout(timeout);
            port.enableReceiveThreshold(threshold);
            return;
        }
        if (timeout < 0) {
            throw new UnsupportedCommOperationException("timeout " + timeout + " < 0");
        }
        if (timeout > 25550) {
            throw new UnsupportedCommOperationException("timeout " + timeout + " > 25550");
        }
        if (threshold < 0) {
            throw new UnsupportedCommOperationException("threshold " + threshold + " < 0");
        }
        if (threshold > 255) {
            throw new UnsupportedCommOperationException("threshold " + threshold + " > 255");
        }
        int FD = ((PureJavaSerialPort)port).getNativeFileDescriptor();
        if (JTermios.tcgetattr(FD, termios2 = new Termios()) != 0) {
            throw new IOException();
        }
        termios2.c_cc[JTermios.VTIME] = (byte)((timeout + 99) / 100);
        termios2.c_cc[JTermios.VMIN] = (byte)threshold;
        if (JTermios.tcsetattr(FD, JTermios.TCSANOW, termios2) != 0) {
            throw new IOException();
        }
    }

    static class RawPosix32bInputStream
    extends RawPosixInputStream {
        CLib m_CLib = new CLib();

        public RawPosix32bInputStream(int fd) {
            super(fd);
        }

        public final int read(byte[] buffer) throws IOException {
            return this.m_CLib.read(this.m_FD, buffer, buffer.length);
        }

        public final int read(byte[] buffer, int offset, int length) throws IOException {
            if (offset == 0) {
                return this.m_CLib.read(this.m_FD, buffer, length);
            }
            return this.m_CLib.read(this.m_FD, ByteBuffer.wrap(buffer, offset, length), length);
        }

        public static class CLib {
            static {
                try {
                    Native.register((String)"c");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public native int read(int var1, byte[] var2, int var3);

            public native int read(int var1, ByteBuffer var2, int var3);
        }
    }

    static class RawPosix64bInputStream
    extends RawPosixInputStream {
        CLib m_CLib = new CLib();

        public RawPosix64bInputStream(int fd) {
            super(fd);
        }

        public final int read(byte[] buffer) throws IOException {
            return (int)this.m_CLib.read(this.m_FD, buffer, (long)buffer.length);
        }

        public final int read(byte[] buffer, int offset, int length) throws IOException {
            if (offset == 0) {
                return (int)this.m_CLib.read(this.m_FD, buffer, (long)length);
            }
            return (int)this.m_CLib.read(this.m_FD, ByteBuffer.wrap(buffer, offset, length), (long)length);
        }

        public static class CLib {
            static {
                try {
                    Native.register((String)"c");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public native long read(int var1, byte[] var2, long var3);

            public native long read(int var1, ByteBuffer var2, long var3);
        }
    }

    static class RawPosixInputStream
    extends InputStream {
        int m_FD;
        private int[] m_Available = new int[1];
        private CLib m_CLib = new CLib();

        protected RawPosixInputStream(int FD) {
            this.m_FD = FD;
        }

        public final int available() throws IOException {
            if (this.m_CLib.ioctl(this.m_FD, JTermios.FIONREAD, this.m_Available) < 0) {
                throw new IOException();
            }
            return this.m_Available[0];
        }

        public final int read() throws IOException {
            byte[] buf = new byte[1];
            int n = this.read(buf, 0, 1);
            return n > 0 ? buf[0] & 0xFF : -1;
        }

        public static class CLib {
            static {
                try {
                    Native.register((String)"c");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public native int ioctl(int var1, int var2, int[] var3);
        }
    }
}

