/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test6
extends TestBase {
    private static Exception m_Exception = null;
    private static Thread m_Receiver;
    private static Thread m_Transmitter;

    static void run() throws Exception {
        try {
            Test6.begin("Test6 - threshold + timeout");
            Test6.openPort();
            m_Port.setSerialPortParams(230400, 8, 1, 0);
            m_Receiver = new Thread(new Runnable(){

                public void run() {
                    try {
                        Test6.sync(2);
                        m_Port.enableReceiveThreshold(4);
                        m_Port.enableReceiveTimeout(10000);
                        byte[] b = new byte[4];
                        int i = 0;
                        while (i < 1000) {
                            long T0 = System.currentTimeMillis();
                            int n = m_In.read(b);
                            long dT = System.currentTimeMillis() - T0;
                            if (n != 4) {
                                Test6.fail("read did not get 4 bytes as expected, got %d ", n);
                            }
                            if (dT >= 1000L) {
                                Test6.fail("read timed out though we got 4 bytes " + dT, new Object[0]);
                            }
                            ++i;
                        }
                    }
                    catch (InterruptedException b) {
                    }
                    catch (Exception e) {
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter = new Thread(new Runnable(){

                public void run() {
                    try {
                        Test6.sync(2);
                        int i = 0;
                        while (i < 1000) {
                            m_Out.write(new byte[4]);
                            ++i;
                        }
                    }
                    catch (InterruptedException i) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter.start();
            Test6.sleep(100);
            m_Receiver.start();
            while (m_Receiver.isAlive() || m_Transmitter.isAlive()) {
                Test6.sleep(100);
            }
            if (m_Exception != null) {
                throw m_Exception;
            }
            Test6.finishedOK();
        }
        finally {
            Test6.closePort();
        }
    }
}

