/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.util.ArrayList;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Device;
import net.deepocean.u_gotme.Waypoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointLog {
    private static WaypointLog theInstance = null;
    private ArrayList<Waypoint> theLog = new ArrayList();
    private Device.DeviceType deviceType = Device.DeviceType.DEVICETYPE_UNKNOWN;

    private WaypointLog() {
    }

    public static WaypointLog getInstance() {
        if (theInstance == null) {
            theInstance = new WaypointLog();
        }
        return theInstance;
    }

    public void clear() {
        this.theLog.clear();
    }

    public boolean appendData(byte[] data, int length) {
        if (length % Waypoint.WAYPOINT_RECORDSIZE != 0) {
            DebugLogger.error("Waypoint data has invalid length");
        }
        boolean hasMoreData = true;
        int count = 0;
        int maxCount = length / Waypoint.WAYPOINT_RECORDSIZE;
        while (hasMoreData && count < maxCount) {
            int offset = Waypoint.WAYPOINT_RECORDSIZE * count;
            int start = (data[offset + 0] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
            if (start == 35670106) {
                int latitude = (data[offset + 4] & 0xFF) + ((data[offset + 5] & 0xFF) << 8) + ((data[offset + 6] & 0xFF) << 16) + (data[offset + 7] << 24);
                int longitude = (data[offset + 8] & 0xFF) + ((data[offset + 9] & 0xFF) << 8) + ((data[offset + 10] & 0xFF) << 16) + (data[offset + 11] << 24);
                int elevation = (data[offset + 12] & 0xFF) + ((data[offset + 13] & 0xFF) << 8) + ((data[offset + 14] & 0xFF) << 16) + (data[offset + 15] << 24);
                long time = (data[offset + 16] & 0xFF) + ((data[offset + 17] & 0xFF) << 8) + ((data[offset + 18] & 0xFF) << 16) + ((data[offset + 19] & 0xFF) << 24);
                int id = (data[offset + 20] & 0xFF) + ((data[offset + 21] & 0xFF) << 8) + ((data[offset + 22] & 0xFF) << 16) + ((data[offset + 23] & 0xFF) << 24);
                Waypoint point = new Waypoint(time, longitude, latitude, elevation, id);
                this.theLog.add(point);
                ++count;
                continue;
            }
            hasMoreData = false;
        }
        return hasMoreData;
    }

    public int getNumberOfEntries() {
        return this.theLog.size();
    }

    public void dumpLog() {
        for (Waypoint point : this.theLog) {
            DebugLogger.info(point.toString());
        }
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.theLog;
    }

    public void setDeviceType(Device.DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Device.DeviceType getDeviceType() {
        return this.deviceType;
    }
}

