/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.deepocean.u_gotme.Coordinate;

public class Waypoint
extends Coordinate {
    public static long EPOCH_1999_12_31_00_00_00 = 946598400L;
    public static int WAYPOINT_RECORDSIZE = 24;
    private DateTime timeStamp;
    private int id;

    public Waypoint(long time, int longitude, int latitude, int elevation, int id) {
        super(longitude, latitude, elevation);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateTimeString = formatter.format(new Date((time + EPOCH_1999_12_31_00_00_00) * 1000L));
        this.timeStamp = new DateTime(dateTimeString);
        this.id = id;
    }

    public int getId() {
        return this.id + 100;
    }

    public DateTime getDateTime() {
        return this.timeStamp;
    }

    public String toString() {
        return new String("Waypoint " + String.format("%3d", this.getId()) + " " + this.timeStamp.format("DD-MM-YYYY hh:mm:ss") + " " + "Lon " + String.format("%5.3f", this.getLongitude()) + " " + "Lat " + String.format("%5.3f", this.getLatitude()) + " " + "Ele " + String.format("%5.3f", this.getElevation()));
    }
}

