/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.ArrayList;
import java.util.Iterator;
import net.deepocean.u_gotme.HeartRatePoint;
import net.deepocean.u_gotme.Settings;
import net.deepocean.u_gotme.TrackLogPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackSegment {
    private static int nextSegmentId = 0;
    private int trackSegmentNo = nextSegmentId++;
    private ArrayList<TrackLogPoint> trackPoints = new ArrayList();
    private ArrayList<TrackLogPoint> wayPoints = new ArrayList();
    private ArrayList<HeartRatePoint> heartRatePoints = new ArrayList();

    public static void reset() {
        nextSegmentId = 0;
    }

    public void appendTrackpoint(TrackLogPoint point) {
        this.trackPoints.add(point);
    }

    public void appendWaypoint(TrackLogPoint point) {
        this.wayPoints.add(point);
    }

    public void appendHeartRatePoints(ArrayList<HeartRatePoint> points) {
        this.heartRatePoints.addAll(points);
    }

    public void finish() {
        this.parseHeartRates();
    }

    private void parseHeartRates() {
        HeartRatePoint heartRatePoint = null;
        TrackLogPoint trackPoint = null;
        Iterator<TrackLogPoint> trackLogIterator = this.trackPoints.iterator();
        Iterator<HeartRatePoint> heartRateIterator = this.heartRatePoints.iterator();
        boolean exit = false;
        if (heartRateIterator.hasNext()) {
            heartRatePoint = heartRateIterator.next();
        } else {
            heartRatePoint = null;
            exit = true;
        }
        if (trackLogIterator.hasNext()) {
            trackPoint = trackLogIterator.next();
        } else {
            trackPoint = null;
            exit = true;
        }
        double sum = 0.0;
        int count = 0;
        while (!exit) {
            DateTime trackPointDateTime = trackPoint.getDateTime();
            DateTime heartRateDateTime = heartRatePoint.getDateTime();
            if (trackPoint.pointIsStartOfTrack) {
                sum = 0.0;
                count = 0;
            }
            if (heartRateDateTime.lteq(trackPointDateTime)) {
                if (heartRatePoint.getHeartRateValue() > 0) {
                    sum += (double)heartRatePoint.getHeartRateValue();
                    ++count;
                }
                if (heartRateIterator.hasNext()) {
                    heartRatePoint = heartRateIterator.next();
                    continue;
                }
                heartRatePoint = null;
                exit = true;
                continue;
            }
            if (count > 0) {
                trackPoint.setHeartRate((int)(sum / (double)count));
                sum = 0.0;
                count = 0;
            } else {
                trackPoint.setHeartRate(-1);
            }
            if (trackLogIterator.hasNext()) {
                trackPoint = trackLogIterator.next();
                continue;
            }
            trackPoint = null;
            exit = true;
        }
        if (count > 0 && trackPoint != null) {
            trackPoint.setHeartRate((int)(sum / (double)count));
        }
        while (trackLogIterator.hasNext()) {
            trackPoint = trackLogIterator.next();
            trackPoint.setHeartRate(-1);
        }
    }

    public int getSegmentId() {
        return this.trackSegmentNo;
    }

    public int getNumberOfWaypoints() {
        return this.wayPoints.size();
    }

    public int getNumberOfTrackpoints() {
        return this.trackPoints.size();
    }

    public int getNumberOfHeartRatePoints() {
        return this.heartRatePoints.size();
    }

    public boolean isEmptySegment() {
        boolean isEmpty = this.wayPoints.size() <= 0 && this.trackPoints.size() <= 0 && this.heartRatePoints.size() <= 0;
        return isEmpty;
    }

    public ArrayList<TrackLogPoint> getTrackPoints() {
        return this.trackPoints;
    }

    public ArrayList<TrackLogPoint> getWayPoints() {
        return this.wayPoints;
    }

    public ArrayList<HeartRatePoint> getHeartRatePoints() {
        return this.heartRatePoints;
    }

    public DateTime getStartTime() {
        DateTime pointDateTime;
        DateTime dateTime = null;
        if (this.trackPoints.size() > 0) {
            dateTime = this.trackPoints.get(0).getDateTime();
        }
        if (this.wayPoints.size() > 0) {
            pointDateTime = this.wayPoints.get(0).getDateTime();
            if (dateTime == null) {
                dateTime = pointDateTime;
            } else if (pointDateTime.lt(dateTime)) {
                dateTime = pointDateTime;
            }
        }
        if (this.heartRatePoints.size() > 0) {
            pointDateTime = this.heartRatePoints.get(0).getDateTime();
            if (dateTime == null) {
                dateTime = pointDateTime;
            } else if (pointDateTime.lt(dateTime)) {
                dateTime = pointDateTime;
            }
        }
        return dateTime;
    }

    public DateTime getEndTime() {
        DateTime pointDateTime;
        DateTime dateTime = null;
        if (this.trackPoints.size() > 0) {
            dateTime = this.trackPoints.get(this.trackPoints.size() - 1).getDateTime();
        }
        if (this.wayPoints.size() > 0) {
            pointDateTime = this.wayPoints.get(this.wayPoints.size() - 1).getDateTime();
            if (dateTime == null) {
                dateTime = pointDateTime;
            } else if (pointDateTime.gt(dateTime)) {
                dateTime = pointDateTime;
            }
        }
        if (this.heartRatePoints.size() > 0) {
            pointDateTime = this.heartRatePoints.get(this.heartRatePoints.size() - 1).getDateTime();
            if (dateTime == null) {
                dateTime = pointDateTime;
            } else if (pointDateTime.gt(dateTime)) {
                dateTime = pointDateTime;
            }
        }
        return dateTime;
    }

    public double getSegmentDistance() {
        double distance = 0.0;
        double radius = 6371000.0;
        Iterator<TrackLogPoint> iterator = this.trackPoints.iterator();
        if (iterator.hasNext()) {
            TrackLogPoint prevPoint = iterator.next();
            while (iterator.hasNext()) {
                TrackLogPoint point = iterator.next();
                double lat1 = Math.PI * 2 * prevPoint.getLatitude() / 360.0;
                double lon1 = Math.PI * 2 * prevPoint.getLongitude() / 360.0;
                double lat2 = Math.PI * 2 * point.getLatitude() / 360.0;
                double lon2 = Math.PI * 2 * point.getLongitude() / 360.0;
                distance += Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1)) * radius;
                prevPoint = point;
            }
        }
        return distance;
    }

    public double getSegmentMaxSpeed() {
        double speedMax = 0.0;
        for (TrackLogPoint point : this.trackPoints) {
            double speed = point.getSpeed();
            if (!(speed > speedMax)) continue;
            speedMax = speed;
        }
        return speedMax;
    }

    public long getSegmentDuration() {
        long duration = 0L;
        DateTime start = this.getStartTime();
        DateTime end = this.getEndTime();
        if (start != null && end != null) {
            duration = start.numSecondsFrom(end);
        }
        return duration;
    }

    public double getSegmentCalories() {
        double calories = 0.0;
        Settings settings = Settings.getInstance();
        double age = settings.getProfileAge();
        double length = settings.getProfileLength();
        double weight = settings.getProfileWeight();
        String gender = settings.getProfileGender();
        double metabolicEquivalent = settings.getMetabolicEquivalent();
        boolean isMale = gender.equals("male");
        double restMetabolicRate = isMale ? 10.0 * weight + 6.25 * length - 5.0 * age + 5.0 : 10.0 * weight + 6.25 * length - 5.0 * age - 161.0;
        Iterator<TrackLogPoint> iterator = this.trackPoints.iterator();
        if (iterator.hasNext()) {
            TrackLogPoint prevPoint = iterator.next();
            while (iterator.hasNext()) {
                TrackLogPoint point = iterator.next();
                DateTime time = point.getDateTime();
                DateTime prevTime = prevPoint.getDateTime();
                double seconds = prevTime.numSecondsFrom(time);
                double rate = point.getHeartRate();
                double burned = rate > 0.0 ? (isMale ? (age * 0.2017 + weight * 0.1988 + rate * 0.6309 - 55.0969) * (seconds / 60.0) / 4.184 : (age * 0.074 + weight * 0.1263 + rate * 0.4472 - 20.4022) * (seconds / 60.0) / 4.184) : metabolicEquivalent * restMetabolicRate / 24.0 * seconds / 3600.0;
                calories += burned;
                prevPoint = point;
            }
        }
        return calories;
    }
}

