/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.ArrayList;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Device;
import net.deepocean.u_gotme.HeartRatePoint;
import net.deepocean.u_gotme.ToolBox;
import net.deepocean.u_gotme.Track;
import net.deepocean.u_gotme.TrackLogPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackLog {
    private static boolean counterResetFound = false;
    private static int prevMillis = 65535;
    private static TrackLogPoint previousPoint = null;
    private static int RECORDLENGTH = 32;
    static TrackLog theInstance = null;
    private byte[] record = new byte[RECORDLENGTH];
    private ArrayList<Track> tracks = new ArrayList();
    private Device.DeviceType deviceType;
    private Track currentTrack;
    private boolean stateIsLogging;

    private TrackLog() {
    }

    public static TrackLog getInstance() {
        if (theInstance == null) {
            theInstance = new TrackLog();
        }
        return theInstance;
    }

    public void appendData(byte[] data, int length) {
        if (length % RECORDLENGTH != 0) {
            DebugLogger.error("Datalenght not a multiple of 0x20 bytes");
        } else {
            int records = length / RECORDLENGTH;
            for (int i = 0; i < records; ++i) {
                TrackLogPoint point;
                boolean trackStartFound = false;
                ToolBox.copyBytes(data, this.record, i * RECORDLENGTH, RECORDLENGTH);
                int flags = this.record[0] & 0xFF;
                int millis = (this.record[4] & 0xFF) << 8 | this.record[5] & 0xFF;
                int recordPrevMillis = (this.record[30] & 0xFF) << 8 | this.record[31] & 0xFF;
                if (this.deviceType == Device.DeviceType.DEVICETYPE_GT820 || this.deviceType == Device.DeviceType.DEVICETYPE_GT820PRO || this.deviceType == Device.DeviceType.DEVICETYPE_GT900 || this.deviceType == Device.DeviceType.DEVICETYPE_GT900PRO) {
                    if (flags == 241) {
                        byte[] logBytes = new byte[24];
                        ToolBox.copyBytes(this.record, logBytes, 6, 24);
                        String logString = new String(logBytes);
                        if (logString.startsWith("RESET COUNTER")) {
                            if (this.stateIsLogging) {
                                this.newTrack();
                            }
                        } else if (logString.startsWith("POWER UP")) {
                            if (!this.stateIsLogging) {
                                this.newTrack();
                            }
                            this.stateIsLogging = true;
                        } else if (logString.startsWith("!!!SYSTEM OFF")) {
                            this.stateIsLogging = false;
                        }
                    } else if (flags == 245) {
                        ArrayList<HeartRatePoint> newHeartRatePoints = HeartRatePoint.parseHeartRateRecord(this.record);
                        this.currentTrack.appendHeartRates(newHeartRatePoints);
                    } else if ((flags & 0x10) == 0) {
                        point = new TrackLogPoint(this.record, this.deviceType);
                        if (point.isWaypoint()) {
                            this.currentTrack.appendWaypoint(point);
                        } else {
                            this.currentTrack.appendTrackpoint(point);
                        }
                    }
                } else if (this.deviceType == Device.DeviceType.DEVICETYPE_GT800 || this.deviceType == Device.DeviceType.DEVICETYPE_GT800PRO) {
                    if ((flags & 0x10) == 0) {
                        if ((flags & 0x40) != 0) {
                            this.newTrack();
                        }
                        if ((point = new TrackLogPoint(this.record, this.deviceType)).isWaypoint()) {
                            this.currentTrack.appendWaypoint(point);
                        } else {
                            this.currentTrack.appendTrackpoint(point);
                        }
                    }
                } else if (this.deviceType == Device.DeviceType.DEVICETYPE_GT120) {
                    if ((flags & 0x40) != 0) {
                        this.newTrack();
                    } else if ((flags & 0x10) == 0 && this.record[1] != 0) {
                        point = new TrackLogPoint(this.record, this.deviceType);
                        if (point.isWaypoint()) {
                            this.currentTrack.appendWaypoint(point);
                        } else {
                            this.currentTrack.appendTrackpoint(point);
                        }
                    }
                }
                if (prevMillis != 65535 && (this.deviceType == Device.DeviceType.DEVICETYPE_GT800 || this.deviceType == Device.DeviceType.DEVICETYPE_GT800PRO || this.deviceType == Device.DeviceType.DEVICETYPE_GT820 || this.deviceType == Device.DeviceType.DEVICETYPE_GT820PRO || this.deviceType == Device.DeviceType.DEVICETYPE_GT900 || this.deviceType == Device.DeviceType.DEVICETYPE_GT900PRO) && recordPrevMillis != prevMillis) {
                    DebugLogger.error("Missing record(s) detected while parsing waypoints");
                }
                prevMillis = millis;
            }
        }
    }

    public void initialiseTracklog() {
        this.tracks.clear();
        Track.reset();
        counterResetFound = false;
        prevMillis = 65535;
        previousPoint = null;
        this.currentTrack = new Track();
        this.stateIsLogging = false;
    }

    public void finishTracklog() {
        if (!this.currentTrack.isEmptyTrack()) {
            this.currentTrack.finish();
            this.tracks.add(this.currentTrack);
        }
    }

    private void newTrack() {
        if (!this.currentTrack.isEmptyTrack()) {
            this.currentTrack.finish();
            this.tracks.add(this.currentTrack);
            this.currentTrack = new Track();
        }
    }

    int getNumberOfRecords() {
        int records = 0;
        for (Track track : this.tracks) {
            records += track.getNumberOfTrackPoints();
            records += track.getNumberOfWaypoints();
        }
        return records;
    }

    void dumpTracks() {
        for (Track track : this.tracks) {
            DebugLogger.info("Track: " + track.getTrackId());
            track.dumpSegments();
        }
    }

    public int getNumberOfTracks() {
        return this.tracks.size();
    }

    public int getNumberOfTrackSegments(int trackNumber) {
        int number;
        if (trackNumber >= 0 && trackNumber < this.tracks.size()) {
            Track track = this.tracks.get(trackNumber);
            number = track.getNumberOfSegments();
        } else {
            number = 0;
        }
        return number;
    }

    public ArrayList<TrackLogPoint> getTrackPoints(int trackNumber, int segmentNumber) {
        return this.tracks.get(trackNumber).getSegment(segmentNumber).getTrackPoints();
    }

    public ArrayList<TrackLogPoint> getWayPoints(int trackNumber, int segmentNumber) {
        return this.tracks.get(trackNumber).getSegment(segmentNumber).getWayPoints();
    }

    public DateTime getTrackStartTime(int trackNumber) {
        return this.tracks.get(trackNumber).getStartTime();
    }

    public ArrayList<HeartRatePoint> getTrackHeartRateLog(int trackNumber) {
        return this.tracks.get(trackNumber).getHeartRateValues();
    }

    public ArrayList<HeartRatePoint> getTrackSegmentHeartRateLog(int trackNumber, int segmentNumber) {
        return this.tracks.get(trackNumber).getSegment(segmentNumber).getHeartRatePoints();
    }

    public double getAverageHeartRate(int trackNumber) {
        return this.tracks.get(trackNumber).getAverageHeartRate();
    }

    public String getTrackDescription(int trackNumber) {
        String description;
        if (trackNumber >= 0 && trackNumber < this.tracks.size()) {
            Track track = this.tracks.get(trackNumber);
            description = track.getDescription();
        } else {
            description = "Non existing track";
        }
        return description;
    }

    public void setDeviceType(Device.DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Device.DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Track getTrack(int trackId) {
        return this.tracks.get(trackId);
    }
}

