/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimeZone;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.HeartRatePoint;
import net.deepocean.u_gotme.Settings;
import net.deepocean.u_gotme.TrackLogPoint;
import net.deepocean.u_gotme.TrackSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track {
    private static int nextTrackId = 0;
    private static TrackLogPoint previousTrackPoint = null;
    private int trackId = nextTrackId++;
    private ArrayList<TrackSegment> segments = new ArrayList();
    private TrackSegment currentSegment;
    private int segmentSeparation;

    public Track() {
        TrackSegment.reset();
        this.currentSegment = new TrackSegment();
        this.segmentSeparation = Settings.getInstance().getSegmentSeparationLimit();
    }

    public static void reset() {
        nextTrackId = 0;
        previousTrackPoint = null;
    }

    public void finish() {
        if (!this.currentSegment.isEmptySegment()) {
            this.currentSegment.finish();
            this.segments.add(this.currentSegment);
        }
    }

    public void appendTrackpoint(TrackLogPoint point) {
        long seconds;
        DateTime dateTime = point.getDateTime();
        if (previousTrackPoint != null) {
            DateTime prevDateTime = previousTrackPoint.getDateTime();
            seconds = prevDateTime.numSecondsFrom(dateTime);
        } else {
            seconds = 0L;
        }
        if (this.segmentSeparation > 0 && seconds > (long)this.segmentSeparation && !this.currentSegment.isEmptySegment()) {
            this.currentSegment.finish();
            this.segments.add(this.currentSegment);
            this.currentSegment = new TrackSegment();
        }
        this.currentSegment.appendTrackpoint(point);
        previousTrackPoint = point;
    }

    public void appendWaypoint(TrackLogPoint point) {
        this.currentSegment.appendWaypoint(point);
    }

    public void appendHeartRates(ArrayList<HeartRatePoint> points) {
        this.currentSegment.appendHeartRatePoints(points);
    }

    public DateTime getStartTime() {
        DateTime returnTime = this.segments.size() > 0 ? this.segments.get(0).getStartTime() : null;
        return returnTime;
    }

    public DateTime getLocalStartTime() {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        TimeZone localTimeZone = TimeZone.getDefault();
        DateTime gmtTime = this.getStartTime();
        DateTime localTime = gmtTime != null ? gmtTime.changeTimeZone(gmtTimeZone, localTimeZone) : null;
        return localTime;
    }

    public DateTime getEndTime() {
        DateTime returnTime = this.segments.size() > 0 ? this.segments.get(this.segments.size() - 1).getEndTime() : null;
        return returnTime;
    }

    public DateTime getLocalEndTime() {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        TimeZone localTimeZone = TimeZone.getDefault();
        DateTime gmtTime = this.getEndTime();
        DateTime localTime = gmtTime != null ? gmtTime.changeTimeZone(gmtTimeZone, localTimeZone) : null;
        return localTime;
    }

    public int getTrackId() {
        return this.trackId;
    }

    public void dumpSegments() {
        for (TrackSegment segment : this.segments) {
            DebugLogger.info("Segment " + segment.getSegmentId() + " " + segment.getStartTime().format("YYYY-MM-DD hh:mm") + " " + segment.getEndTime().format("YYYY-MM-DD hh:mm") + " track " + segment.getNumberOfTrackpoints() + " wp " + segment.getNumberOfWaypoints() + " heart " + segment.getNumberOfHeartRatePoints());
        }
    }

    public ArrayList<TrackSegment> getSegments() {
        return this.segments;
    }

    public TrackSegment getSegment(int segmentNumber) {
        TrackSegment segment = segmentNumber >= 0 && segmentNumber < this.segments.size() ? this.segments.get(segmentNumber) : null;
        return segment;
    }

    public int getNumberOfSegments() {
        return this.segments.size();
    }

    public int getNumberOfTrackPoints() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        int number = 0;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            number += segment.getNumberOfTrackpoints();
        }
        return number;
    }

    public int getNumberOfWaypoints() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        int number = 0;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            number += segment.getNumberOfWaypoints();
        }
        return number;
    }

    public int getNumberOfHeartRatePoints() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        int number = 0;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            number += segment.getNumberOfHeartRatePoints();
        }
        return number;
    }

    public ArrayList<HeartRatePoint> getHeartRateValues() {
        ArrayList<HeartRatePoint> rates = new ArrayList<HeartRatePoint>();
        for (TrackSegment segment : this.segments) {
            rates.addAll(segment.getHeartRatePoints());
        }
        return rates;
    }

    public double getAverageHeartRate() {
        ArrayList<HeartRatePoint> rates = this.getHeartRateValues();
        double averageHeartRate = 0.0;
        int count = 0;
        for (HeartRatePoint point : rates) {
            int heartRate = point.getHeartRateValue();
            if (heartRate <= 0) continue;
            ++count;
            averageHeartRate += (double)heartRate;
        }
        averageHeartRate = count > 0 ? (averageHeartRate /= (double)count) : -1.0;
        return averageHeartRate;
    }

    public int getMaxHeartRate() {
        ArrayList<HeartRatePoint> rates = this.getHeartRateValues();
        int max = -1;
        for (HeartRatePoint point : rates) {
            int heartRate = point.getHeartRateValue();
            if (heartRate <= 0 || heartRate <= max) continue;
            max = heartRate;
        }
        return max;
    }

    public double getCalories() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        double calories = 0.0;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            calories += segment.getSegmentCalories();
        }
        return calories;
    }

    public boolean isEmptyTrack() {
        boolean isEmpty = true;
        if (this.segments.size() > 0) {
            isEmpty = false;
        } else if (!this.currentSegment.isEmptySegment()) {
            isEmpty = false;
        }
        return isEmpty;
    }

    public String getDescription() {
        String description = "Track " + String.format("%4d", this.getTrackId()) + " " + this.getLocalStartTime().format("YYYY-MM-DD hh:mm") + " - " + this.getLocalEndTime().format("hh:mm") + " segments: " + String.format("%4d", this.getNumberOfSegments()) + " trackpnts: " + String.format("%6d", this.getNumberOfTrackPoints()) + " waypnts: " + String.format("%6d", this.getNumberOfWaypoints()) + " heartrate " + String.format("%6d", this.getNumberOfHeartRatePoints());
        return description;
    }

    public double getTrackDistance() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        double distance = 0.0;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            distance += segment.getSegmentDistance();
        }
        return distance;
    }

    public double getTrackMaxSpeed() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        double speedMax = 0.0;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            double speed = segment.getSegmentMaxSpeed();
            if (!(speed > speedMax)) continue;
            speedMax = speed;
        }
        return speedMax;
    }

    public long getTrackDuration() {
        Iterator<TrackSegment> iterator = this.segments.iterator();
        long duration = 0L;
        while (iterator.hasNext()) {
            TrackSegment segment = iterator.next();
            duration += segment.getSegmentDuration();
        }
        return duration;
    }

    public long getTotalTrackDuration() {
        long duration = 0L;
        int size = this.segments.size();
        if (size > 0) {
            DateTime start = this.segments.get(0).getStartTime();
            DateTime end = this.segments.get(size - 1).getEndTime();
            duration = start.numSecondsFrom(end);
        }
        return duration;
    }
}

