/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Device;
import net.deepocean.u_gotme.IgotuWriter;
import net.deepocean.u_gotme.RouteLog;
import net.deepocean.u_gotme.Track;
import net.deepocean.u_gotme.TrackLog;
import net.deepocean.u_gotme.TrackLogPoint;
import net.deepocean.u_gotme.WaypointLog;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TcxWriter
implements IgotuWriter {
    private static TcxWriter theInstance = null;
    private TrackLog trackLog = TrackLog.getInstance();
    private WaypointLog waypointLog = WaypointLog.getInstance();
    private RouteLog routeLog = RouteLog.getInstance();
    private int trackPoints;
    private int wayPoints;
    private String gpxVersion;
    Document doc;
    Element tcxElement;

    private TcxWriter() {
    }

    public static TcxWriter getInstance() {
        if (theInstance == null) {
            theInstance = new TcxWriter();
        }
        return theInstance;
    }

    private void createGpxDocument(Device.DeviceType deviceType) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.tcxElement = this.doc.createElement("TrainingCenterDatabase");
        this.doc.appendChild(this.tcxElement);
        String creator = new String("u-gotMe - ") + Device.getDeviceTypeDescription(deviceType);
        this.addTcxHeader(this.doc, this.tcxElement, creator);
    }

    void writeTcxDocument(String fileName) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(new File(fileName));
        transformer.transform(source, result);
    }

    private void addTcxHeader(Document doc, Element tcxElement, String creator) {
        Attr attr = doc.createAttribute("xmlns");
        attr.setValue("http://www.garmin.com/xmlschemas/TrainingCenterDatabase/v2");
        tcxElement.setAttributeNode(attr);
        attr = doc.createAttribute("xmlns:xsi");
        attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
        tcxElement.setAttributeNode(attr);
        attr = doc.createAttribute("xsi:schemaLocation");
        attr.setValue("http://www.garmin.com/xmlschemas/TrainingCenterDatabase/v2 http://www.garmin.com/xmlschemas/TrainingCenterDatabasev2.xsd");
        tcxElement.setAttributeNode(attr);
    }

    private void appendTrackTcx(Document doc, Element trackElement, int trackNo, int segmentNo) {
        ArrayList<TrackLogPoint> points = this.trackLog.getTrackPoints(trackNo, segmentNo);
        for (TrackLogPoint point : points) {
            Element pointElement = doc.createElement("Trackpoint");
            trackElement.appendChild(pointElement);
            Element element = doc.createElement("Time");
            DateTime dateTime = point.getDateTime();
            String dateTimeString = dateTime.format("YYYY-MM-DD") + "T" + dateTime.format("hh:mm:ss") + "Z";
            element.appendChild(doc.createTextNode(dateTimeString));
            pointElement.appendChild(element);
            Element positionElement = doc.createElement("Position");
            pointElement.appendChild(positionElement);
            element = doc.createElement("LatitudeDegrees");
            element.appendChild(doc.createTextNode(String.valueOf(point.getLatitude())));
            positionElement.appendChild(element);
            element = doc.createElement("LongitudeDegrees");
            element.appendChild(doc.createTextNode(String.valueOf(point.getLongitude())));
            positionElement.appendChild(element);
            element = doc.createElement("AltitudeMeters");
            element.appendChild(doc.createTextNode(String.valueOf(point.getElevation())));
            pointElement.appendChild(element);
            element = doc.createElement("DistanceMeters");
            element.appendChild(doc.createTextNode(String.valueOf(point.getElevation())));
            pointElement.appendChild(element);
            int heartRate = point.getHeartRate();
            if (heartRate > 0) {
                Element heartRateElement = doc.createElement("HeartRateBpm");
                pointElement.appendChild(heartRateElement);
                Attr attr = doc.createAttribute("xsi:type");
                attr.setValue("HeartRateInBeatsPerMinute_t");
                heartRateElement.setAttributeNode(attr);
                element = doc.createElement("Value");
                element.appendChild(doc.createTextNode(Long.toString(heartRate)));
                heartRateElement.appendChild(element);
            }
            ++this.trackPoints;
        }
    }

    private void addTrack(Document doc, Element gpxElement, int trackNo, String trackName) {
        Element heartRateElement;
        Track track = this.trackLog.getTrack(trackNo);
        int numberOfSegments = this.trackLog.getNumberOfTrackSegments(trackNo);
        Element foldersElement = doc.createElement("Folders");
        gpxElement.appendChild(foldersElement);
        Element activitiesElement = doc.createElement("Activities");
        gpxElement.appendChild(activitiesElement);
        Element activityElement = doc.createElement("Activity");
        activitiesElement.appendChild(activityElement);
        Attr attr = doc.createAttribute("Sport");
        attr.setValue("Other");
        activityElement.setAttributeNode(attr);
        DateTime dateTime = this.trackLog.getTrackStartTime(trackNo);
        String dateTimeString = dateTime.format("YYYY-MM-DD") + "T" + dateTime.format("hh:mm:ss") + "Z";
        Element idElement = doc.createElement("Id");
        idElement.appendChild(doc.createTextNode(dateTimeString));
        activityElement.appendChild(idElement);
        Element lapElement = doc.createElement("Lap");
        attr = doc.createAttribute("StartTime");
        attr.setValue(dateTimeString);
        lapElement.setAttributeNode(attr);
        activityElement.appendChild(lapElement);
        Element element = doc.createElement("TotalTimeSeconds");
        element.appendChild(doc.createTextNode(Long.toString(track.getTotalTrackDuration())));
        lapElement.appendChild(element);
        element = doc.createElement("DistanceMeters");
        element.appendChild(doc.createTextNode(Double.toString(track.getTrackDistance())));
        lapElement.appendChild(element);
        element = doc.createElement("MaximumSpeed");
        element.appendChild(doc.createTextNode(Double.toString(track.getTrackMaxSpeed())));
        lapElement.appendChild(element);
        long kCal = Math.round(track.getCalories());
        element = doc.createElement("Calories");
        element.appendChild(doc.createTextNode(Long.toString(kCal)));
        lapElement.appendChild(element);
        long heartRate = Math.round(track.getAverageHeartRate());
        if (heartRate > 0L) {
            heartRateElement = doc.createElement("AverageHeartRateBpm");
            lapElement.appendChild(heartRateElement);
            attr = doc.createAttribute("xsi:type");
            attr.setValue("HeartRateInBeatsPerMinute_t");
            heartRateElement.setAttributeNode(attr);
            element = doc.createElement("Value");
            element.appendChild(doc.createTextNode(Long.toString(heartRate)));
            heartRateElement.appendChild(element);
        }
        if ((heartRate = (long)track.getMaxHeartRate()) > 0L) {
            heartRateElement = doc.createElement("MaximumHeartRateBpm");
            lapElement.appendChild(heartRateElement);
            attr = doc.createAttribute("xsi:type");
            attr.setValue("HeartRateInBeatsPerMinute_t");
            heartRateElement.setAttributeNode(attr);
            element = doc.createElement("Value");
            element.appendChild(doc.createTextNode(Long.toString(heartRate)));
            heartRateElement.appendChild(element);
        }
        element = doc.createElement("Intensity");
        element.appendChild(doc.createTextNode("Active"));
        lapElement.appendChild(element);
        element = doc.createElement("TriggerMethod");
        element.appendChild(doc.createTextNode("Manual"));
        lapElement.appendChild(element);
        Element trackElement = doc.createElement("Track");
        lapElement.appendChild(trackElement);
        for (int i = 0; i < numberOfSegments; ++i) {
            this.appendTrackTcx(doc, trackElement, trackNo, i);
        }
    }

    public void writeTrackToFile(String fileName, int trackNo, String trackName) {
        this.wayPoints = 0;
        this.trackPoints = 0;
        try {
            this.createGpxDocument(this.trackLog.getDeviceType());
            this.addTrack(this.doc, this.tcxElement, trackNo, trackName);
            this.writeTcxDocument(fileName);
            DebugLogger.info("TcxWriter says: 'File saved to " + fileName + "!'");
            DebugLogger.info("Track: " + trackName + ", track points: " + this.trackPoints + ", wayPoints: " + this.wayPoints);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
    }

    public void writeWaypointsToFile(String fileName) {
    }

    public void writeRouteToFile(String fileName) {
    }

    public void writeHeartRateToFile(String fileName, int trackNo) {
    }
}

