/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Symbol;

public class SymbolRepository {
    private static final String SYMBOLSFILE = "symbols.txt";
    private static final String DELIMETER = ";";
    private static final String COMMENTDELIMETER = "#";
    private static SymbolRepository theInstance = null;
    private ArrayList<Symbol> symbols = new ArrayList();

    private SymbolRepository() {
        this.readSymbols();
        if (this.symbols.size() == 0) {
            DebugLogger.error("No symbols found!");
        }
    }

    private void readSymbols() {
        this.symbols.clear();
        try {
            String line;
            FileInputStream fstream = new FileInputStream(SYMBOLSFILE);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                String[] splitLine;
                StringTokenizer tokenizer;
                if (line.startsWith(COMMENTDELIMETER) || (tokenizer = new StringTokenizer((splitLine = line.split(COMMENTDELIMETER))[0], DELIMETER)).countTokens() != 17) continue;
                String token = tokenizer.nextToken().trim();
                int id = Integer.parseInt(token);
                String name = tokenizer.nextToken().trim();
                int[] bitmap = new int[15];
                for (int i = 0; i < 15; ++i) {
                    token = tokenizer.nextToken().trim();
                    bitmap[i] = Integer.parseInt(token, 16);
                }
                Symbol symbol = new Symbol(id, name, bitmap);
                this.symbols.add(symbol);
            }
            in.close();
        }
        catch (IOException e) {
            DebugLogger.error("Error reading symbols file symbols.txt");
        }
    }

    public static SymbolRepository getInstance() {
        if (theInstance == null) {
            theInstance = new SymbolRepository();
        }
        return theInstance;
    }

    public int[] getSymbolBitmap(String symbolName) {
        Symbol symbol;
        int[] symbolBitmap = null;
        Iterator<Symbol> i = this.symbols.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            symbol = i.next();
            if (!symbol.getName().toLowerCase().equals(symbolName.toLowerCase())) continue;
            found = true;
            symbolBitmap = symbol.getBitmap();
        }
        if (!found && this.symbols.size() > 0) {
            symbol = this.symbols.get(0);
            symbolBitmap = symbol.getBitmap();
        }
        return symbolBitmap;
    }

    public String getSymbolNameById(int id) {
        String symbolName = "";
        Iterator<Symbol> i = this.symbols.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            Symbol symbol = i.next();
            if (symbol.getId() != id) continue;
            found = true;
            symbolName = symbol.getName();
        }
        return symbolName;
    }

    public int getSymbolIdByName(String name) {
        int id = 0;
        Iterator<Symbol> i = this.symbols.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            Symbol symbol = i.next();
            if (!symbol.getName().toLowerCase().equals(name.toLowerCase().trim())) continue;
            found = true;
            id = symbol.getId();
        }
        return id;
    }
}

