/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.util.ArrayList;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Device;
import net.deepocean.u_gotme.RoutePoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteLog {
    private static RouteLog theInstance = null;
    private ArrayList<RoutePoint> theLog = new ArrayList();
    private Device.DeviceType deviceType = Device.DeviceType.DEVICETYPE_UNKNOWN;
    private static int nextRoutePointNumber;

    private RouteLog() {
        this.clear();
    }

    public static RouteLog getInstance() {
        if (theInstance == null) {
            theInstance = new RouteLog();
        }
        return theInstance;
    }

    public void clear() {
        this.theLog.clear();
        nextRoutePointNumber = 1;
    }

    public boolean appendData(byte[] data, int length) {
        byte[] theData = new byte[288];
        if (length % 288 != 0) {
            DebugLogger.error("Route Waypoint data has invalid length");
        }
        boolean hasMoreData = true;
        int count = 0;
        int maxCount = length / 288;
        while (hasMoreData && count < maxCount) {
            int offset = 288 * count;
            int start = (data[offset + 0] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
            if (start == 35670200) {
                for (int i = 0; i < 288; ++i) {
                    theData[i] = data[offset + i];
                }
                RoutePoint point = new RoutePoint(theData, nextRoutePointNumber);
                this.theLog.add(point);
                ++nextRoutePointNumber;
                ++count;
                continue;
            }
            hasMoreData = false;
        }
        return hasMoreData;
    }

    public void appendWaypoint(RoutePoint waypoint) {
        this.theLog.add(waypoint);
    }

    public int getNumberOfEntries() {
        return this.theLog.size();
    }

    public void dumpLog() {
        for (RoutePoint point : this.theLog) {
            DebugLogger.info(point.toString());
        }
    }

    public ArrayList<RoutePoint> getWaypoints() {
        return this.theLog;
    }

    public byte[] getWaypointAsByteArray(int index) {
        byte[] record = index < this.theLog.size() ? this.theLog.get(index).getRecordAsByteArray() : null;
        return record;
    }

    public void setDeviceType(Device.DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Device.DeviceType getDeviceType() {
        return this.deviceType;
    }
}

