/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.deepocean.u_gotme.Coordinate;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.RouteLog;
import net.deepocean.u_gotme.RoutePoint;
import net.deepocean.u_gotme.TrackLog;
import net.deepocean.u_gotme.TrackLogPoint;
import net.deepocean.u_gotme.Waypoint;
import net.deepocean.u_gotme.WaypointLog;

public class MapFrame
extends JFrame {
    private static final int MAXSTRINGLENGTH = 1700;
    private static final int MAXCOMPRESSIONPARAMS = 7;
    private static final int[] compressionParamPoints = new int[]{0, 25, 500, 1000, 1500, 2000, 2500, 3000};
    private static final double[] compressionParamMaxSlopeDev = new double[]{0.0, 0.2, 0.3, 0.6, 0.7, 0.8, 0.85, 0.9};
    private int compressionParamIndex = 6;
    JLabel label;
    Coordinate firstPoint;
    Coordinate lastPoint;
    int totalPointCount;
    int compressedPointCount;
    Coordinate previousEncodedPoint = null;
    double maxSlopeDeviation = 5.0E-4;
    String resultString;
    public static final String MAPTYPE_ROAD = "roadmap";
    public static final String MAPTYPE_SATELLITE = "satellite";
    public static final String MAPTYPE_TERRAIN = "terrain";
    public static final String MAPTYPE_HYBRID = "hybrid";
    private static String mapType = "roadmap";

    public MapFrame() {
        this.setResizable(false);
        JPanel panel = new JPanel();
        this.label = new JLabel();
        panel.add(this.label);
        this.add(panel);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static String getMapType() {
        return mapType;
    }

    public static void setMapType(String newMapType) {
        if (newMapType.equals(MAPTYPE_ROAD) || newMapType.equals(MAPTYPE_SATELLITE) || newMapType.equals(MAPTYPE_TERRAIN) || newMapType.equals(MAPTYPE_HYBRID)) {
            mapType = newMapType;
            DebugLogger.info("Map type set to " + mapType);
        }
    }

    private String getMapString() {
        String mapString = "http://maps.googleapis.com/maps/api/staticmap?size=480x480&sensor=false&maptype=" + mapType;
        return mapString;
    }

    void setCompressionParameter(int numberOfPoints) {
        boolean found = false;
        this.compressionParamIndex = 6;
        while (!found && this.compressionParamIndex > 0) {
            if (numberOfPoints < compressionParamPoints[this.compressionParamIndex]) {
                --this.compressionParamIndex;
                continue;
            }
            found = true;
        }
        this.maxSlopeDeviation = compressionParamMaxSlopeDev[this.compressionParamIndex];
        DebugLogger.debug("Number of points: " + numberOfPoints + " factor: " + this.maxSlopeDeviation);
    }

    boolean setHigherCompression() {
        boolean done = false;
        if (this.compressionParamIndex < 6) {
            ++this.compressionParamIndex;
            this.maxSlopeDeviation = compressionParamMaxSlopeDev[this.compressionParamIndex];
            DebugLogger.debug("Next factor: " + this.maxSlopeDeviation);
            done = true;
        }
        return done;
    }

    void resetCompression() {
        this.firstPoint = null;
        this.lastPoint = null;
        this.totalPointCount = 0;
        this.compressedPointCount = 0;
    }

    Coordinate compress(Coordinate point) {
        Coordinate returnPoint = null;
        ++this.totalPointCount;
        if (this.firstPoint == null) {
            returnPoint = point;
            this.firstPoint = point;
        } else if (this.lastPoint == null) {
            this.lastPoint = point;
        } else {
            Coordinate midPoint = this.lastPoint;
            this.lastPoint = point;
            double x1 = this.firstPoint.getLongitude();
            double y1 = this.firstPoint.getLatitude();
            double xm = midPoint.getLongitude();
            double ym = midPoint.getLatitude();
            double x2 = this.lastPoint.getLongitude();
            double y2 = this.lastPoint.getLatitude();
            double factor = Math.sqrt((ym - y1) * (ym - y1) + (xm - x1) * (xm - x1)) * this.maxSlopeDeviation;
            boolean deviates = false;
            double slope = x2 - xm;
            double averageSlope = xm - x1;
            if (slope >= averageSlope + factor || slope <= averageSlope - factor) {
                deviates = true;
            }
            if ((slope = y2 - ym) >= (averageSlope = ym - y1) + factor || slope <= averageSlope - factor) {
                deviates = true;
            }
            if (deviates) {
                returnPoint = midPoint;
                this.firstPoint = midPoint;
            }
        }
        if (returnPoint != null) {
            ++this.compressedPointCount;
        }
        return returnPoint;
    }

    Coordinate finishCompression() {
        DebugLogger.info("Track compressed: skipped " + (this.totalPointCount - this.compressedPointCount) + " points out of " + this.totalPointCount);
        if (this.totalPointCount > 0) {
            DebugLogger.debug("Compressed to " + 100 * this.compressedPointCount / this.totalPointCount + "% @ max. allowed slope delta " + this.maxSlopeDeviation);
        }
        return this.lastPoint;
    }

    private void resetPointEncoding() {
        this.previousEncodedPoint = null;
    }

    private String encodePoint(Coordinate point) {
        String encodedPointString = "";
        if (this.previousEncodedPoint == null) {
            encodedPointString = encodedPointString + this.encodeValue(point.getLatitude());
            encodedPointString = encodedPointString + this.encodeValue(point.getLongitude());
        } else {
            double deltaLat = point.getLatitude() - this.previousEncodedPoint.getLatitude();
            double deltaLon = point.getLongitude() - this.previousEncodedPoint.getLongitude();
            encodedPointString = encodedPointString + this.encodeValue(deltaLat);
            encodedPointString = encodedPointString + this.encodeValue(deltaLon);
        }
        this.previousEncodedPoint = point;
        return encodedPointString;
    }

    private String encodeValue(double value) {
        boolean isNegative;
        String conversion = "";
        boolean finished = false;
        if (value < 0.0) {
            value = -value;
            isNegative = true;
        } else {
            isNegative = false;
        }
        int binValue = (int)Math.round(value *= 100000.0);
        if (binValue == 0) {
            isNegative = false;
        }
        if (isNegative) {
            binValue ^= 0xFFFFFFFF;
            ++binValue;
        }
        binValue <<= 1;
        if (isNegative) {
            binValue ^= 0xFFFFFFFF;
        }
        for (int i = 0; i < 6 && !finished; ++i) {
            int charCode = binValue & 0x1F;
            binValue >>= 5;
            if (i < 5) {
                int nextCharCode = binValue >> (i + 1) * 5 & 0x1F;
                if (binValue > 0) {
                    charCode |= 0x20;
                } else {
                    finished = true;
                }
            }
            char theChar = (char)(charCode += 63);
            conversion = conversion + theChar;
        }
        return conversion;
    }

    String convertTrackMarkers(int trackNo, int maxStringLength) {
        String markerString = "";
        return markerString;
    }

    String compressAndConvertTrack(int trackNo, int maxStringLength) {
        ArrayList<TrackLogPoint> points;
        int segment;
        String trackString = "";
        TrackLog trackLog = TrackLog.getInstance();
        int numberOfSegments = trackLog.getNumberOfTrackSegments(trackNo);
        int numberOfTrackPoints = 0;
        for (segment = 0; segment < numberOfSegments; ++segment) {
            points = trackLog.getTrackPoints(trackNo, segment);
            numberOfTrackPoints += points.size();
        }
        this.setCompressionParameter(numberOfTrackPoints);
        boolean maxCompressionReached = false;
        boolean found = false;
        while (!found && !maxCompressionReached) {
            boolean bailOut = false;
            trackString = "";
            for (segment = 0; segment < numberOfSegments && !bailOut; ++segment) {
                String pointString;
                Coordinate compressedPoint;
                this.resetCompression();
                this.resetPointEncoding();
                String pathString = segment % 2 > 0 ? "path=color:blue|enc:" : "path=color:red|enc:";
                if (trackString.length() + pathString.length() < maxStringLength) {
                    trackString = trackString + pathString;
                } else {
                    bailOut = true;
                }
                points = trackLog.getTrackPoints(trackNo, segment);
                Iterator<TrackLogPoint> iterator = points.iterator();
                while (iterator.hasNext() && !bailOut) {
                    TrackLogPoint point = iterator.next();
                    compressedPoint = this.compress(point);
                    if (compressedPoint == null) continue;
                    pointString = this.encodePoint(compressedPoint);
                    if (trackString.length() + pointString.length() < maxStringLength) {
                        trackString = trackString + pointString;
                        continue;
                    }
                    bailOut = true;
                }
                compressedPoint = this.finishCompression();
                if (compressedPoint != null) {
                    pointString = this.encodePoint(compressedPoint);
                    if (trackString.length() + pointString.length() < maxStringLength) {
                        trackString = trackString + pointString;
                    } else {
                        bailOut = true;
                    }
                }
                if (segment >= numberOfSegments - 1 || bailOut) continue;
                trackString = trackString + '&';
            }
            if (!bailOut) {
                found = true;
                continue;
            }
            maxCompressionReached = !this.setHigherCompression();
        }
        if (!found) {
            this.resultString = "Track truncated for printing. Too much points";
            DebugLogger.info(this.resultString);
        }
        return trackString;
    }

    String compressAndConvertRoute(int maxStringLength) {
        String pointString;
        Coordinate compressedPoint;
        RoutePoint point;
        RouteLog routeLog = RouteLog.getInstance();
        int numberOfRoutePoints = routeLog.getNumberOfEntries();
        this.setCompressionParameter(numberOfRoutePoints);
        boolean bailOut = false;
        ArrayList<RoutePoint> points = routeLog.getWaypoints();
        this.resetCompression();
        this.resetPointEncoding();
        String routeString = "path=color:0xff0000|weight:5|enc:";
        Iterator<RoutePoint> iterator = points.iterator();
        while (iterator.hasNext() && !bailOut) {
            point = iterator.next();
            compressedPoint = this.compress(point);
            if (compressedPoint == null) continue;
            pointString = this.encodePoint(compressedPoint);
            if (routeString.length() + pointString.length() < maxStringLength) {
                routeString = routeString + pointString;
                continue;
            }
            bailOut = true;
        }
        compressedPoint = this.finishCompression();
        if (compressedPoint != null) {
            pointString = this.encodePoint(compressedPoint);
            if (routeString.length() + pointString.length() < maxStringLength) {
                routeString = routeString + pointString;
            } else {
                bailOut = true;
            }
        }
        if (!bailOut) {
            String markersString = "&markers=color:blue|label:S|";
            point = points.get(0);
            markersString = markersString + point.getLatitude() + "," + point.getLongitude();
            markersString = markersString + "&markers=color:green|label:F|";
            point = points.get(points.size() - 1);
            markersString = markersString + point.getLatitude() + "," + point.getLongitude();
            if (routeString.length() + markersString.length() < maxStringLength) {
                routeString = routeString + markersString;
            }
        }
        if (bailOut) {
            this.resultString = "Route truncated for printing. Too much points";
            DebugLogger.info(this.resultString);
        }
        return routeString;
    }

    private String convertWaypoints(int maxStringLength) {
        String markersString;
        WaypointLog waypointLog = WaypointLog.getInstance();
        ArrayList<Waypoint> points = waypointLog.getWaypoints();
        Iterator<Waypoint> iterator = points.iterator();
        if (iterator.hasNext()) {
            markersString = "markers=color:blue";
            boolean bailOut = false;
            while (iterator.hasNext() && !bailOut) {
                Waypoint point = iterator.next();
                String waypointString = "|" + point.getLatitude() + "," + point.getLongitude();
                if (markersString.length() + waypointString.length() < maxStringLength) {
                    markersString = markersString + waypointString;
                    continue;
                }
                this.resultString = "Waypoints truncated, to much waypoints to show on map";
                DebugLogger.info(this.resultString);
                bailOut = true;
            }
        } else {
            markersString = null;
            this.resultString = "There are no waypoints to show";
            DebugLogger.error(this.resultString);
        }
        return markersString;
    }

    public String showTrack(int trackNo) {
        this.resultString = "Track shown";
        String trackString = this.getMapString() + "&";
        trackString = trackString + this.compressAndConvertTrack(trackNo, 1700 - trackString.length());
        DebugLogger.debug("Google URL: " + trackString + " Length: " + trackString.length());
        BufferedImage image = null;
        try {
            image = ImageIO.read(new URL(trackString));
            this.label.setIcon(new ImageIcon(image));
            this.pack();
        }
        catch (Exception e) {
            this.resultString = "Unable to get Google map";
            DebugLogger.error(this.resultString + ": " + e.getMessage());
            this.dispose();
        }
        return this.resultString;
    }

    public String showWaypoints() {
        this.resultString = "Waypoints shown";
        String mapString = this.getMapString() + "&";
        String markersString = this.convertWaypoints(1700 - mapString.length());
        mapString = mapString + markersString;
        if (markersString != null) {
            DebugLogger.debug("Google URL: " + mapString + " Length: " + mapString.length());
            BufferedImage image = null;
            try {
                image = ImageIO.read(new URL(mapString));
                this.label.setIcon(new ImageIcon(image));
                this.pack();
            }
            catch (Exception e) {
                this.resultString = "Unable to get Google map";
                DebugLogger.error(this.resultString + ": " + e.getMessage());
                this.dispose();
            }
        }
        return this.resultString;
    }

    String showRoute() {
        this.resultString = "Route shown";
        String trackString = this.getMapString() + "&";
        trackString = trackString + this.compressAndConvertRoute(1700 - trackString.length());
        DebugLogger.debug("Google URL: " + trackString + " Length: " + trackString.length());
        BufferedImage image = null;
        try {
            image = ImageIO.read(new URL(trackString));
            this.label.setIcon(new ImageIcon(image));
            this.pack();
        }
        catch (Exception e) {
            this.resultString = "Unable to get Google map";
            DebugLogger.error(this.resultString + ": " + e.getMessage());
            this.dispose();
        }
        return this.resultString;
    }
}

