/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.deepocean.u_gotme.HeartRatePoint;
import net.deepocean.u_gotme.Track;
import net.deepocean.u_gotme.TrackLogPoint;
import net.deepocean.u_gotme.TrackSegment;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.DefaultShadowGenerator;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphFrame
extends JFrame {
    List<HeartRatePoint> heartRateLog;
    String trackName;

    public GraphFrame() {
        this.setSize(800, 600);
        this.setResizable(false);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)"", (XYDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setShadowGenerator((ShadowGenerator)new DefaultShadowGenerator());
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(false);
            renderer.setBaseShapesFilled(false);
            renderer.setDrawSeriesLineAsPath(true);
        }
        DateAxis timeAxis = (DateAxis)plot.getDomainAxis();
        timeAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
        return chart;
    }

    public JPanel createGraphPanel(JFreeChart chart) {
        ChartPanel panel = new ChartPanel(chart);
        panel.setFillZoomRectangle(true);
        panel.setMouseWheelEnabled(false);
        panel.setPopupMenu(null);
        return panel;
    }

    private XYDataset createHeartrateDataset(List<HeartRatePoint> heartRateLog) {
        TimeSeries chartData = new TimeSeries((Comparable)((Object)"Heartrate"));
        ListIterator<HeartRatePoint> iterator = heartRateLog.listIterator();
        while (iterator.hasNext()) {
            HeartRatePoint point = iterator.next();
            DateTime dateTime = point.getDateTime();
            double heartRateValue = point.getHeartRateValue();
            if (!(heartRateValue > 0.0)) continue;
            Second graphTimeStamp = new Second(dateTime.getSecond().intValue(), dateTime.getMinute().intValue(), dateTime.getHour().intValue(), dateTime.getDay().intValue(), dateTime.getMonth().intValue(), dateTime.getYear().intValue());
            chartData.addOrUpdate((RegularTimePeriod)graphTimeStamp, (double)point.getHeartRateValue());
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(chartData);
        return dataset;
    }

    public String showTrackHeartRateLog(String trackName, List<HeartRatePoint> heartRateLog) {
        JFreeChart chart = this.createChart(this.createHeartrateDataset(heartRateLog));
        chart.setTitle("Heartrate for " + trackName);
        XYPlot plot = chart.getXYPlot();
        plot.getRangeAxis().setRange(0.0, 220.0);
        JPanel graphPanel = this.createGraphPanel(chart);
        this.add(graphPanel);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        String resultString = "";
        return resultString;
    }

    private XYDataset createSpeedDataset(TrackSegment trackSegment) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries chartData = new TimeSeries((Comparable)((Object)"Speed"));
        ListIterator<TrackLogPoint> iterator = trackSegment.getTrackPoints().listIterator();
        while (iterator.hasNext()) {
            TrackLogPoint point = iterator.next();
            DateTime dateTime = point.getDateTime();
            double speedValue = point.getSpeed();
            if (!(speedValue >= 0.0)) continue;
            Second graphTimeStamp = new Second(dateTime.getSecond().intValue(), dateTime.getMinute().intValue(), dateTime.getHour().intValue(), dateTime.getDay().intValue(), dateTime.getMonth().intValue(), dateTime.getYear().intValue());
            chartData.addOrUpdate((RegularTimePeriod)graphTimeStamp, speedValue);
        }
        dataset.addSeries(chartData);
        return dataset;
    }

    public String showTrackSpeed(String trackName, Track track) {
        JFreeChart chart = this.createChart(null);
        chart.setTitle("Speed for " + trackName);
        XYPlot plot = chart.getXYPlot();
        plot.getDomainAxis().setLabel("Time");
        plot.getRangeAxis().setLabel("Speed (m/s)");
        chart.getXYPlot().getRangeAxis().setAutoRange(true);
        int numberOfSegments = track.getNumberOfSegments();
        for (int segment = 0; segment < numberOfSegments; ++segment) {
            chart.getXYPlot().setDataset(segment, this.createSpeedDataset(track.getSegment(segment)));
            chart.getXYPlot().setRenderer(segment, (XYItemRenderer)new StandardXYItemRenderer());
        }
        JPanel graphPanel = this.createGraphPanel(chart);
        this.add(graphPanel);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        String resultString = "";
        return resultString;
    }
}

