/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.IgotuReader;
import net.deepocean.u_gotme.RouteLog;
import net.deepocean.u_gotme.RoutePoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GpxReader
implements IgotuReader {
    private static GpxReader theInstance = null;

    private GpxReader() {
    }

    public static GpxReader getInstance() {
        if (theInstance == null) {
            theInstance = new GpxReader();
        }
        return theInstance;
    }

    private Element getChildElement(Element parent, String elementName) {
        Element element = null;
        NodeList nodeList = parent.getElementsByTagName(elementName);
        if (nodeList.getLength() == 1) {
            if (nodeList.item(0).getNodeType() == 1) {
                element = (Element)nodeList.item(0);
            }
        } else {
            DebugLogger.error("Number of nodes <" + elementName + "> tags in GPX file not equal to one as expected...");
        }
        return element;
    }

    private String getChildElementValue(Element parent, String tagName) {
        String value;
        Element element = this.getChildElement(parent, tagName);
        if (element != null) {
            NodeList list = element.getChildNodes();
            Node node = list.item(0);
            value = node != null ? node.getNodeValue() : "";
        } else {
            value = "";
            DebugLogger.error("Tag <" + tagName + "> not found in GPX file");
        }
        return value;
    }

    public void readRouteFromFile(String fileName) {
        RouteLog routeLog = RouteLog.getInstance();
        routeLog.clear();
        try {
            File fXmlFile = new File(fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            Element gpxElement = doc.getDocumentElement();
            if (gpxElement.getNodeName().equals("gpx")) {
                Element routeElement = this.getChildElement(gpxElement, "rte");
                NodeList nList = routeElement != null ? routeElement.getElementsByTagName("rtept") : gpxElement.getElementsByTagName("wpt");
                if (nList != null && nList.getLength() > 0) {
                    for (int i = 0; i < nList.getLength(); ++i) {
                        Node nNode = nList.item(i);
                        if (nNode.getNodeType() != 1) continue;
                        Element eElement = (Element)nNode;
                        double longitude = Double.parseDouble(eElement.getAttribute("lon"));
                        double latitude = Double.parseDouble(eElement.getAttribute("lat"));
                        String name = this.getChildElementValue(eElement, "name");
                        String symbol = this.getChildElementValue(eElement, "sym");
                        String value = this.getChildElementValue(eElement, "ele");
                        double elevation = !value.equals("") ? Double.parseDouble(value) : 0.0;
                        elevation = 0.0;
                        RoutePoint waypoint = new RoutePoint((int)(longitude * 1.0E7), (int)(latitude * 1.0E7), (int)(elevation * 100.0), name, symbol);
                        routeLog.appendWaypoint(waypoint);
                    }
                } else {
                    DebugLogger.error("No <rte> or <wpt> data in GPX file");
                }
                routeLog.dumpLog();
            } else {
                DebugLogger.error(fileName + " does not seem to be a GPX file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

