/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.DeviceLogEntry;
import net.deepocean.u_gotme.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceLog {
    private static DeviceLog theInstance = null;
    private ArrayList<DeviceLogEntry> theLog = new ArrayList();

    private DeviceLog() {
    }

    public static DeviceLog getInstance() {
        if (theInstance == null) {
            theInstance = new DeviceLog();
        }
        return theInstance;
    }

    public void appendData(byte[] data, int length) {
        if (length % 32 == 0) {
            int number = length / 32;
            byte[] logString = new byte[24];
            for (int i = 0; i < number; ++i) {
                if ((data[i * 32 + 0] & 0xFF) != 241) continue;
                DateTime dateTime = ToolBox.bytesToDateTime(data[i * 32 + 1], data[i * 32 + 2], data[i * 32 + 3], data[i * 32 + 4], data[i * 32 + 5]);
                for (int j = 0; j < 24; ++j) {
                    int nextByte = data[i * 32 + 6 + j];
                    logString[j] = nextByte != 0 ? nextByte : 32;
                }
                DeviceLogEntry entry = new DeviceLogEntry(dateTime, new String(logString));
                this.theLog.add(entry);
                DebugLogger.debug("Device Log entry: " + entry.toString());
            }
        } else {
            DebugLogger.error("Invalid block size when converting data to DeviceLog");
        }
    }

    public void clear() {
        this.theLog.clear();
    }

    public ArrayList<DeviceLogEntry> getDeviceLogEntries() {
        return this.theLog;
    }

    public int getNumberOfEntries() {
        return this.theLog.size();
    }

    public void writeToFile(String fileName) {
        try {
            FileWriter outFile = new FileWriter(fileName);
            PrintWriter out = new PrintWriter(outFile);
            Iterator<DeviceLogEntry> iterator = this.theLog.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                DeviceLogEntry entry = iterator.next();
                out.println(String.format("%4d", count) + ": " + entry.toString());
                ++count;
            }
            out.close();
        }
        catch (IOException e) {
            DebugLogger.error("Error writing file " + fileName);
        }
    }
}

