/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import hirondelle.date4j.DateTime;
import java.util.TimeZone;

public class DebugLogger {
    public static final int DEBUGLEVEL_DEBUG = 0;
    public static final int DEBUGLEVEL_INFO = 1;
    public static final int DEBUGLEVEL_ERROR = 2;
    public static final int DEBUGLEVEL_OFF = 3;
    private static int debugLevel = 2;

    private DebugLogger() {
    }

    public static void setDebugLevel(int newDebugLevel) {
        if (newDebugLevel >= 0 && newDebugLevel <= 3) {
            debugLevel = newDebugLevel;
        }
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void debug(String info) {
        if (debugLevel <= 0) {
            DateTime time = DateTime.now((TimeZone)TimeZone.getDefault());
            System.out.println("d " + time.format("YYYY-MM-DD hh:mm:ss  ") + info);
        }
    }

    public static void info(String info) {
        if (debugLevel <= 1) {
            DateTime time = DateTime.now((TimeZone)TimeZone.getDefault());
            System.out.println("i " + time.format("YYYY-MM-DD hh:mm:ss  ") + info);
        }
    }

    public static void error(String info) {
        if (debugLevel <= 2) {
            DateTime time = DateTime.now((TimeZone)TimeZone.getDefault());
            System.err.println("e " + time.format("YYYY-MM-DD hh:mm:ss  ERROR: ") + info);
        }
    }

    public static String debugLevelToString(int debugLevel) {
        String returnString = "unknown";
        if (debugLevel == 3) {
            returnString = "off";
        } else if (debugLevel == 0) {
            returnString = "debug";
        } else if (debugLevel == 1) {
            returnString = "info";
        } else if (debugLevel == 2) {
            returnString = "error";
        }
        return returnString;
    }

    public static String debugLevelToString() {
        String returnString = "unknown";
        if (debugLevel == 3) {
            returnString = "off";
        } else if (debugLevel == 0) {
            returnString = "debug";
        } else if (debugLevel == 1) {
            returnString = "info";
        } else if (debugLevel == 2) {
            returnString = "error";
        }
        return returnString;
    }
}

