/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Device;
import net.deepocean.u_gotme.HeartRatePoint;
import net.deepocean.u_gotme.IgotuWriter;
import net.deepocean.u_gotme.RouteLog;
import net.deepocean.u_gotme.RoutePoint;
import net.deepocean.u_gotme.Track;
import net.deepocean.u_gotme.TrackLog;
import net.deepocean.u_gotme.TrackLogPoint;
import net.deepocean.u_gotme.TrackSegment;
import net.deepocean.u_gotme.Waypoint;
import net.deepocean.u_gotme.WaypointLog;

public class CsvWriter
implements IgotuWriter {
    private static CsvWriter theInstance = null;
    private static final String SEPARATOR = ";";

    private CsvWriter() {
    }

    public static CsvWriter getInstance() {
        if (theInstance == null) {
            theInstance = new CsvWriter();
        }
        return theInstance;
    }

    private void writeDeviceInfo(PrintWriter writer, Device.DeviceType type) {
        writer.write("Device;" + Device.getDeviceTypeDescription(type) + "\n");
        writer.write("\n");
    }

    private void writeTrackInfo(PrintWriter writer, Track track) {
        writer.write("Start;" + track.getLocalStartTime().format("YYYY-MM-DD hh:mm:ss") + "\n");
        writer.write("End;" + track.getLocalEndTime().format("YYYY-MM-DD hh:mm:ss") + "\n");
        writer.write("Average heart rate (bpm);" + track.getAverageHeartRate() + "\n");
        writer.write("Maximum heart rate (bpm);" + track.getMaxHeartRate() + "\n");
        writer.write("Calories estimation (kCal);" + track.getCalories() + "\n");
        writer.write("Segments;" + track.getNumberOfSegments() + "\n");
        writer.write("Trackpoints;" + track.getNumberOfTrackPoints() + "\n");
        writer.write("Waypoints;" + track.getNumberOfWaypoints() + "\n");
        writer.write("Heartrate points;" + track.getNumberOfHeartRatePoints() + "\n");
        writer.write("\n");
    }

    private void writeTrackHeader(PrintWriter writer) {
        writer.print("Date-time");
        writer.print(SEPARATOR);
        writer.print("Latitude (deg)");
        writer.print(SEPARATOR);
        writer.print("Longitude (deg)");
        writer.print(SEPARATOR);
        writer.print("Barometric height (m)");
        writer.print(SEPARATOR);
        writer.print("GPS heigth (m)");
        writer.print(SEPARATOR);
        writer.print("Speed (m/s)");
        writer.print(SEPARATOR);
        writer.print("Heading (deg)");
        writer.print(SEPARATOR);
        writer.print("Precision (m)");
        writer.print(SEPARATOR);
        writer.print("Number of satellites");
        writer.print(SEPARATOR);
        writer.print("Heart rate (bpm)");
        writer.print("\n");
    }

    private void writeTrackPoint(PrintWriter writer, TrackLogPoint point) {
        writer.print(point.getDateTime().format("YYYY-MM-DD hh:mm:ss"));
        writer.print(SEPARATOR);
        writer.print(Double.toString(point.getLatitude()));
        writer.print(SEPARATOR);
        writer.print(Double.toString(point.getLongitude()));
        writer.print(SEPARATOR);
        writer.print(Double.toString(point.getElevationByAtmosphericPresure()));
        writer.print(SEPARATOR);
        writer.print(Double.toString(point.getElevationByGps()));
        writer.print(SEPARATOR);
        writer.print(Double.toString(point.getSpeed()));
        writer.print(SEPARATOR);
        writer.print(Double.toString(point.getCourse()));
        writer.print(SEPARATOR);
        writer.print(point.getEhpe());
        writer.print(SEPARATOR);
        writer.print(point.getSatelliteNumber());
        writer.print(SEPARATOR);
        writer.print(point.getHeartRate());
        writer.print("\n");
    }

    public void writeTrackToFile(String fileName, int trackNo, String trackName) {
        TrackLog log = TrackLog.getInstance();
        Track track = log.getTrack(trackNo);
        try {
            ArrayList<TrackLogPoint> points;
            FileWriter fw = new FileWriter(fileName);
            PrintWriter pw = new PrintWriter(fw);
            this.writeDeviceInfo(pw, log.getDeviceType());
            this.writeTrackInfo(pw, track);
            pw.write("WAYPOINTS\n");
            this.writeTrackHeader(pw);
            ArrayList<TrackSegment> segments = track.getSegments();
            for (TrackSegment segment : segments) {
                points = segment.getWayPoints();
                for (TrackLogPoint point : points) {
                    this.writeTrackPoint(pw, point);
                }
            }
            pw.write("\n");
            pw.write("TRACKPOINTS\n");
            this.writeTrackHeader(pw);
            segments = track.getSegments();
            for (TrackSegment segment : segments) {
                points = segment.getTrackPoints();
                for (TrackLogPoint point : points) {
                    this.writeTrackPoint(pw, point);
                }
            }
            pw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            DebugLogger.error("Error writing to file " + fileName + ": " + e.toString());
        }
    }

    private void writeWaypointInfo(PrintWriter writer, WaypointLog log) {
        writer.print("Number of waypoints;" + log.getNumberOfEntries() + "\n");
        writer.print("\n");
    }

    private void writeWaypointHeader(PrintWriter writer) {
        writer.print("ID");
        writer.print(SEPARATOR);
        writer.print("Latitude (deg)");
        writer.print(SEPARATOR);
        writer.print("Longitude (deg)");
        writer.print(SEPARATOR);
        writer.print("Elevation (m)");
        writer.print("\n");
    }

    private void writeWaypoint(PrintWriter writer, Waypoint point) {
        writer.print(point.getId());
        writer.print(SEPARATOR);
        writer.print(point.getLatitude());
        writer.print(SEPARATOR);
        writer.print(point.getLongitude());
        writer.print(SEPARATOR);
        writer.print(point.getElevation());
        writer.print("\n");
    }

    public void writeWaypointsToFile(String fileName) {
        WaypointLog log = WaypointLog.getInstance();
        ArrayList<Waypoint> points = log.getWaypoints();
        Iterator<Waypoint> iterator = points.iterator();
        try {
            FileWriter fw = new FileWriter(fileName);
            PrintWriter pw = new PrintWriter(fw);
            this.writeDeviceInfo(pw, log.getDeviceType());
            this.writeWaypointInfo(pw, log);
            pw.write("WAYPOINT LOG\n");
            this.writeWaypointHeader(pw);
            while (iterator.hasNext()) {
                Waypoint point = iterator.next();
                this.writeWaypoint(pw, point);
            }
            pw.write("\n");
            pw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            DebugLogger.error("Error writing to file " + fileName + ": " + e.toString());
        }
    }

    private void writeRouteInfo(PrintWriter writer, RouteLog log) {
        writer.print("Number of route points;" + log.getNumberOfEntries() + "\n");
        writer.print("\n");
    }

    private void writeRouteHeader(PrintWriter writer) {
        writer.print("Name");
        writer.print(SEPARATOR);
        writer.print("Latitude (deg)");
        writer.print(SEPARATOR);
        writer.print("Longitude (deg)");
        writer.print(SEPARATOR);
        writer.print("Elevation (m)");
        writer.print(SEPARATOR);
        writer.print("Symbol");
        writer.print("\n");
    }

    private void writeRoutePoint(PrintWriter writer, RoutePoint point) {
        writer.print(point.getName());
        writer.print(SEPARATOR);
        writer.print(point.getLatitude());
        writer.print(SEPARATOR);
        writer.print(point.getLongitude());
        writer.print(SEPARATOR);
        writer.print(point.getElevation());
        writer.print(SEPARATOR);
        writer.print(point.getSymbolName());
        writer.print("\n");
    }

    public void writeRouteToFile(String fileName) {
        RouteLog log = RouteLog.getInstance();
        ArrayList<RoutePoint> points = log.getWaypoints();
        Iterator<RoutePoint> iterator = points.iterator();
        try {
            FileWriter fw = new FileWriter(fileName);
            PrintWriter pw = new PrintWriter(fw);
            this.writeDeviceInfo(pw, log.getDeviceType());
            this.writeRouteInfo(pw, log);
            pw.write("ROUTE\n");
            this.writeRouteHeader(pw);
            while (iterator.hasNext()) {
                RoutePoint point = iterator.next();
                this.writeRoutePoint(pw, point);
            }
            pw.write("\n");
            pw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            DebugLogger.error("Error writing Route to file " + fileName + ": " + e.toString());
        }
    }

    public void writeHeartRateToFile(String fileName, int trackNo) {
        TrackLog log = TrackLog.getInstance();
        ArrayList<HeartRatePoint> rates = log.getTrackHeartRateLog(trackNo);
        if (rates != null) {
            try {
                FileWriter fw = new FileWriter(fileName);
                PrintWriter pw = new PrintWriter(fw);
                pw.print("DateTime (UTC)");
                pw.print(",");
                pw.print("heart rate (bpm)\n");
                ListIterator iterator = rates.listIterator();
                while (iterator.hasNext()) {
                    HeartRatePoint rate = (HeartRatePoint)iterator.next();
                    if (rate.getHeartRateValue() <= 0) continue;
                    pw.print(rate.getDateTime().format("YYYY-MM-DD hh:mm:ss"));
                    pw.print(",");
                    pw.print(rate.getHeartRateValue());
                    pw.print("\n");
                }
                pw.flush();
                pw.close();
                fw.close();
            }
            catch (IOException e) {
                DebugLogger.error("Error writing to file " + fileName + ": " + e.toString());
            }
        }
    }
}

