/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import net.deepocean.u_gotme.ConnectionSerial;
import net.deepocean.u_gotme.DebugLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionSerialRxtx
extends ConnectionSerial
implements SerialPortEventListener {
    private static CommPortIdentifier portId1;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SerialPort serialPort1;

    @Override
    public ArrayList<String> getComportList() {
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> ports = new ArrayList<String>();
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier pid = (CommPortIdentifier)portIdentifiers.nextElement();
            ports.add(pid.getName());
        }
        return ports;
    }

    @Override
    public void open(String comport) {
        try {
            portId1 = CommPortIdentifier.getPortIdentifier((String)comport);
        }
        catch (Exception e) {
            DebugLogger.error("Error while getting comport ID for comport " + comport);
        }
        try {
            this.serialPort1 = (SerialPort)portId1.open("igotu2gpx2", 2000);
            DebugLogger.info("Comport " + portId1.getName() + " opened");
        }
        catch (PortInUseException e) {
            DebugLogger.error("Error opening comport " + comport + ": port in use");
        }
        try {
            this.inputStream = this.serialPort1.getInputStream();
            this.outputStream = this.serialPort1.getOutputStream();
        }
        catch (IOException e) {
            DebugLogger.error("IO Exception while getting comport streams");
        }
        try {
            this.serialPort1.addEventListener((SerialPortEventListener)this);
            DebugLogger.debug("Eventlistener added");
        }
        catch (TooManyListenersException e) {
            DebugLogger.error("Error adding eventlistener - to many listeners");
        }
        this.serialPort1.notifyOnDataAvailable(true);
    }

    @Override
    public void close() {
        if (this.serialPort1 != null) {
            this.serialPort1.removeEventListener();
            this.serialPort1.close();
        }
        DebugLogger.info("Comport closed");
    }

    @Override
    int comportRead(byte[] buffer) {
        int bytesRead = 0;
        try {
            bytesRead = this.inputStream.read(buffer);
        }
        catch (IOException e) {
            DebugLogger.error("Error receiving bytes");
        }
        return bytesRead;
    }

    @Override
    boolean comportWrite(byte[] buffer, int length) {
        try {
            this.outputStream.write(buffer, 0, length);
        }
        catch (IOException e) {
            DebugLogger.error("IO Exception writing to comport");
        }
        return false;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                this.handeRxEvent();
            }
        }
    }
}

