/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import net.deepocean.u_gotme.ConnectionSerial;
import net.deepocean.u_gotme.DebugLogger;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionSerialPurejava
extends ConnectionSerial
implements SerialPortEventListener {
    private static CommPortIdentifier portId;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SerialPort serialPort;

    @Override
    public ArrayList<String> getComportList() {
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> ports = new ArrayList<String>();
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier pid = (CommPortIdentifier)portIdentifiers.nextElement();
            ports.add(pid.getName());
        }
        return ports;
    }

    @Override
    public void open(String comport) {
        try {
            portId = CommPortIdentifier.getPortIdentifier(comport);
        }
        catch (Exception e) {
            DebugLogger.error("Error while getting comport ID for comport " + comport);
        }
        try {
            this.serialPort = (SerialPort)portId.open("igotu2gpx2", 2000);
            DebugLogger.info("Comport " + portId.getName() + " opened");
        }
        catch (PortInUseException e) {
            DebugLogger.error("Error opening comport " + comport + ": port in use");
        }
        try {
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        catch (IOException e) {
            DebugLogger.error("IO Exception while getting comport streams");
        }
        try {
            this.serialPort.addEventListener(this);
            DebugLogger.debug("Eventlistener added");
        }
        catch (TooManyListenersException e) {
            DebugLogger.error("Error adding eventlistener - to many listeners");
        }
        this.serialPort.notifyOnDataAvailable(true);
        try {
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            DebugLogger.error("Error configuring port");
        }
    }

    @Override
    public void close() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
        }
        DebugLogger.info("Comport closed");
    }

    @Override
    int comportRead(byte[] buffer) {
        int bytesRead = 0;
        try {
            bytesRead = this.inputStream.read(buffer);
        }
        catch (IOException e) {
            DebugLogger.error("Error receiving bytes");
        }
        return bytesRead;
    }

    @Override
    boolean comportWrite(byte[] buffer, int length) {
        try {
            this.outputStream.write(buffer, 0, length);
        }
        catch (IOException e) {
            DebugLogger.error("IO Exception writing to comport");
        }
        return false;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                this.handeRxEvent();
            }
        }
    }
}

