/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.util.ArrayList;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import net.deepocean.u_gotme.ConnectionSerial;
import net.deepocean.u_gotme.DebugLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionSerialJssc
extends ConnectionSerial
implements SerialPortEventListener {
    private SerialPort serialPort1;

    @Override
    public ArrayList<String> getComportList() {
        String[] portList = SerialPortList.getPortNames();
        ArrayList<String> ports = new ArrayList<String>();
        for (int i = 0; i < portList.length; ++i) {
            ports.add(portList[i]);
        }
        return ports;
    }

    @Override
    public void open(String comport) {
        this.serialPort1 = new SerialPort(comport);
        try {
            this.serialPort1.openPort();
        }
        catch (SerialPortException e) {
            DebugLogger.error("Error opening comport " + comport + ": " + e.getMessage());
        }
        try {
            this.serialPort1.setParams(9600, 8, 1, 0);
        }
        catch (SerialPortException e) {
            DebugLogger.error("Error configuring port " + e.getMessage());
        }
        try {
            int mask = 1;
            this.serialPort1.setEventsMask(mask);
            this.serialPort1.addEventListener(this);
            DebugLogger.debug("Eventlistener added");
        }
        catch (SerialPortException e) {
            DebugLogger.error("Error adding eventlistener - " + e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.serialPort1 != null) {
            try {
                this.serialPort1.removeEventListener();
                this.serialPort1.closePort();
                this.serialPort1 = null;
            }
            catch (SerialPortException e) {
                DebugLogger.error("Error closing comport: " + e.getMessage());
            }
        }
        DebugLogger.info("Comport closed");
    }

    @Override
    int comportRead(byte[] buffer) {
        int bytesRead = 0;
        try {
            bytesRead = 0;
            if (this.serialPort1 != null && this.serialPort1.getInputBufferBytesCount() > 0) {
                byte[] comportBuffer = this.serialPort1.readBytes();
                bytesRead = comportBuffer.length;
                for (int i = 0; i < bytesRead; ++i) {
                    buffer[i] = comportBuffer[i];
                }
            }
        }
        catch (SerialPortException e) {
            DebugLogger.error("Error reading comport " + e.getMessage());
        }
        return bytesRead;
    }

    @Override
    boolean comportWrite(byte[] buffer, int length) {
        try {
            this.serialPort1.writeBytes(buffer);
        }
        catch (SerialPortException e) {
            DebugLogger.error("IO Exception writing to comport: " + e.getMessage());
        }
        return false;
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        if (event.isRXCHAR()) {
            this.handeRxEvent();
        }
    }
}

