/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import net.deepocean.u_gotme.Command;
import net.deepocean.u_gotme.DebugLogger;
import net.deepocean.u_gotme.Device;
import net.deepocean.u_gotme.ProgressListener;

public class CommunicationProcess
implements Runnable {
    private static CommunicationProcess theInstance = null;
    private boolean running;
    private boolean finished;
    private Command command;
    private ProgressListener listener;
    private String parameter;
    private String outputString;
    private Thread theThread;
    private Device device;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommunicationProcess() {
        CommunicationProcess communicationProcess = this;
        synchronized (communicationProcess) {
            this.running = false;
            this.finished = false;
        }
        this.theThread = new Thread(this);
        this.theThread.start();
        this.device = Device.getInstance();
    }

    public static CommunicationProcess getInstance() {
        if (theInstance == null) {
            theInstance = new CommunicationProcess();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeCommand(Command command, ProgressListener listener, String param) {
        CommunicationProcess communicationProcess = this;
        synchronized (communicationProcess) {
            this.listener = listener;
            this.command = command;
            this.parameter = param;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getResult() {
        String resultString;
        CommunicationProcess communicationProcess = this;
        synchronized (communicationProcess) {
            resultString = new String(this.outputString);
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exit() {
        CommunicationProcess communicationProcess = this;
        synchronized (communicationProcess) {
            this.finished = true;
            this.notify();
        }
    }

    private void downloadTracks(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.downloadTracks(listener);
        this.device.close();
    }

    private void downloadWaypoints(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.downloadWaypoints(listener);
        this.device.close();
    }

    private void getInfo(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.getInfo(listener);
        this.device.close();
    }

    private void eraseTracks(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.eraseTracks(listener);
        this.device.close();
    }

    private void getDeviceType(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.getDeviceType(listener);
        this.device.close();
    }

    private void uploadRoute(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.uploadRoute(listener);
        this.device.close();
    }

    private void downloadRoute(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.downloadRoute(listener);
        this.device.close();
    }

    private void eraseRoute(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.eraseRoute(listener);
        this.device.close();
    }

    private void saveSimulationSet(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.simulationDump(this.parameter, listener);
        this.device.close();
    }

    private void saveDeviceSettings(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.saveDeviceSettings(this.parameter, listener);
        this.device.close();
    }

    private void restoreDeviceSettings(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.restoreDeviceSettings(this.parameter, listener);
        this.device.close();
    }

    private void saveDeviceSettingsAsText(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.saveDeviceSettingsAsText(this.parameter, listener);
        this.device.close();
    }

    private void verifyCacheFile(String comport, ProgressListener listener) {
        this.device = Device.getInstance();
        this.device.open(comport);
        this.outputString = this.device.verifyCache(listener);
        this.device.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean finishedLocal;
        DebugLogger.debug("Command executing thread started");
        CommunicationProcess communicationProcess = this;
        synchronized (communicationProcess) {
            this.running = true;
            finishedLocal = this.finished;
        }
        while (!finishedLocal) {
            Command commandLocal;
            ProgressListener listenerLocal;
            communicationProcess = this;
            synchronized (communicationProcess) {
                try {
                    DebugLogger.debug("Command executing thread says 'Zzzzzzz'");
                    this.wait();
                    DebugLogger.debug("Command executing thread says 'Wazzup?!'");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                finishedLocal = this.finished;
                listenerLocal = this.listener;
                commandLocal = new Command(this.command);
            }
            if (finishedLocal) continue;
            switch (commandLocal.command) {
                case COMMAND_GETINFO: {
                    this.getInfo(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_DOWNLOADTRACKS: {
                    this.downloadTracks(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_ERASETRACKS: {
                    this.eraseTracks(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_UPLOADROUTE: {
                    this.uploadRoute(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_DOWNLOADROUTE: {
                    this.downloadRoute(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_ERASEROUTE: {
                    this.eraseRoute(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_DOWNLOADWAYPOINTS: {
                    this.downloadWaypoints(commandLocal.comport, listenerLocal);
                    break;
                }
                case COMMAND_GETDEVICETYPE: {
                    this.getDeviceType(commandLocal.comport, this.listener);
                    break;
                }
                case COMMAND_SAVESIMULATIONSET: {
                    this.saveSimulationSet(commandLocal.comport, this.listener);
                    break;
                }
                case COMMAND_SAVEDEVICESETTINGS: {
                    this.saveDeviceSettings(commandLocal.comport, this.listener);
                    break;
                }
                case COMMAND_RESTOREDEVICESETTINGS: {
                    this.restoreDeviceSettings(commandLocal.comport, this.listener);
                    break;
                }
                case COMMAND_SAVEDEVICESETTINGSASTEXT: {
                    this.saveDeviceSettingsAsText(commandLocal.comport, this.listener);
                    break;
                }
                case COMMAND_VERIFYCACHEFILE: {
                    this.verifyCacheFile(commandLocal.comport, this.listener);
                }
            }
            listenerLocal.reportProgress(100);
        }
        DebugLogger.debug("Command executing thread says 'Basta! I quit'");
    }
}

