/*
 * Decompiled with CFR 0.152.
 */
package net.deepocean.u_gotme;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.deepocean.u_gotme.RouteLog;
import net.deepocean.u_gotme.RoutePoint;

public class BitmapPane
extends JPanel {
    private byte[] bitmap = null;

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        RouteLog log = RouteLog.getInstance();
        if (log.getNumberOfEntries() > 0) {
            ArrayList<RoutePoint> points = log.getWaypoints();
            RoutePoint point = points.get(1);
            this.bitmap = point.getBitmap();
        }
        if (this.bitmap != null) {
            for (int y = 0; y < 16; ++y) {
                int x = 0;
                while (x < 128) {
                    int bitmapByte = this.bitmap[y * 16 + x / 8] & 0xFF;
                    for (int dx = 0; dx < 8; ++dx) {
                        int mask = 1 << dx;
                        if ((bitmapByte & mask) == 0) {
                            g.setColor(Color.WHITE);
                        } else {
                            g.setColor(Color.BLACK);
                        }
                        g.drawLine(x, y, x, y);
                        ++x;
                    }
                }
            }
        } else {
            g.setColor(Color.RED);
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    g.drawLine(x, y, x, y);
                }
            }
        }
    }

    public void setBitmap(byte[] bitmap) {
        this.bitmap = bitmap;
    }
}

